package com.icetech.park.service.down.mor.impl;

import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.request.mor.MorPropertySetRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.BaseMorDownServiceImpl;
import com.icetech.park.service.down.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class MorPropertySetServiceImpl extends BaseMorDownServiceImpl<MorPropertySetRequest, Void> {

    @Override
    public ObjectResponse<Void> send(MorPropertySetRequest propertySetRequest, String sn){
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        Message<MorPropertySetRequest> message = new Message<>(deviceInfo.getParkId(), MorDownCmdEnum.属性配置下发.getCmdType(), propertySetRequest);
        //组装参数
        String messageId = downHandle.send(sn, message);
        if (messageId == null) {
            log.info("[端云-属性配置下发] 下发失败，参数:{}", propertySetRequest);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        } else {
            return ObjectResponse.success();
        }
    }

}
