package com.icetech.park.service.down.mor.impl;

import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.MorVersionEnum;
import com.icetech.cloudcenter.domain.request.mor.NotpayCarRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.BaseMorDownServiceImpl;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.MorCacheHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Optional;

@Component
@Slf4j
public class MorNotpayCarServiceImpl extends BaseMorDownServiceImpl<NotpayCarRequest, String> {
    @Autowired
    private MorCacheHandle cacheHandle;

    public ObjectResponse<Integer> send(String sn, String orderNum, Long parkId, NotpayCarRequest notpayCarRequest){
        /*if (redisUtils.exists(MorRedisKeyConstants.NOTPAY_TAG_ANTI_REPEAT + orderNum)) {
            log.info("[标记疑似跟车] 10分钟内有请求视频, notpayCarRequest[{}]", notpayCarRequest);
            return ObjectResponse.failed(CodeConstants.ERROR_405, "10分钟内有请求过视频");
        }*/
        Message<NotpayCarRequest> message = new Message(parkId, MorDownCmdEnum.标记疑似跟车.getCmdType(), notpayCarRequest);
        String messageId = downHandle.send(sn, message);
        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(sn);
        if (deviceInfo != null && MorVersionEnum.getIndex(deviceInfo.getVersion()) > MorVersionEnum.版本1.getIndex()) {
            ObjectResponse<String> responseFromRedis = cacheHandle.getResponseFromRedis(messageId, 3000L);
            if (responseFromRedis == null) {
                return ObjectResponse.success(0);
            }
            Map<String, Object> dataMap = Optional.ofNullable(responseFromRedis.getData())
                    .map(JsonUtils::parseMap)
                    .orElse(null);
            if (dataMap != null) {
                //是否跟车
                Integer carFollow = (Integer) dataMap.get("carFollow");
                return ObjectResponse.success(carFollow);
            }
            return ObjectResponse.success(0);
        }
        //redisUtils.setIfAbsent(MorRedisKeyConstants.NOTPAY_TAG_ANTI_REPEAT + orderNum, 1, 610);
        //默认是跟车
        return ObjectResponse.success(1);
    }
}
