package com.icetech.park.service.down.mor.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.constants.MorRedisKeyConstants;
import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.request.mor.ApplyCarVideoRequest;
import com.icetech.cloudcenter.domain.response.mor.ApplyCarVideoResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.service.OrderBackService;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.service.BaseMorDownServiceImpl;
import com.icetech.park.service.down.Message;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
@Slf4j
public class MorApplyCarVideoServiceImpl extends BaseMorDownServiceImpl<ApplyCarVideoRequest, String> {
    @Autowired
    private RedisUtils redisUtils;
    @Resource
    private OrderNotpayService notpayService;
    @Resource
    private OrderBackService backService;

    public ObjectResponse<String> send(String sn, String orderNum, Long parkId, ApplyCarVideoRequest applyCarVideoRequest){
        boolean lock = redisUtils.setIfAbsent(MorRedisKeyConstants.APPLY_VIDEO_ANTI_REPEAT + orderNum, 1, 6);
        if (!lock) {
            log.info("[请求车辆视频] 6秒内有请求过视频, applyCarVideoRequest[{}]", applyCarVideoRequest);
            return ObjectResponse.failed(CodeConstants.ERROR_405, "6秒内有请求过视频");
        }
        Message<ApplyCarVideoRequest> message = new Message(parkId, MorDownCmdEnum.请求车辆视频.getCmdType(), applyCarVideoRequest);
        String messageId = downHandle.send(sn, message);
        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        ObjectResponse<String> response = cacheHandle.getResponseFromRedis(messageId, 6000L);
        if (!ObjectResponse.isSuccess(response)) {
            return response;
        }
        ApplyCarVideoResponse applyCarVideoResponse = JsonUtils.parseObject(response.getData(), ApplyCarVideoResponse.class);

        log.info("[请求车辆视频] 更新视频地址, 条件：[{}, {}, {}], VideoPath[{}]", applyCarVideoRequest.getVideoType(), orderNum,
                applyCarVideoRequest.getVideoId(), applyCarVideoResponse.getVideoPath());
        if (applyCarVideoRequest.getVideoType() == 1) {
            notpayService.update(Wrappers.lambdaUpdate(OrderNotpay.class)
                    .set(OrderNotpay::getEvidenceVideo, applyCarVideoResponse.getVideoPath())
                    .eq(OrderNotpay::getOrderNum, orderNum)
                    .eq(OrderNotpay::getVideoId, applyCarVideoRequest.getVideoId()));
        } else {
            backService.update(Wrappers.lambdaUpdate(OrderBack.class)
                    .set(OrderBack::getEvidenceVideo, applyCarVideoResponse.getVideoPath())
                    .eq(OrderBack::getOrderNum, orderNum)
                    .eq(OrderBack::getVideoId, applyCarVideoRequest.getVideoId())
            );
        }
        return ObjectResponse.success(applyCarVideoResponse.getVideoPath());
    }

}
