package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.itc.PropertySetRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.ItcDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("itcPropertySetServiceImpl")
@Slf4j
public class ItcPropertySetServiceImpl extends AbstractService implements ResponseService<String>, DownService {
    @Autowired
    private ItcDownHandle downHandle;
    @Autowired
    private ItcCacheHandle cacheHandle;

    public boolean send(PropertySetRequest propertySetRequest, String sn){
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return false;
        }
        Message message = new Message(deviceInfo.getParkId(), ItcDownCmdEnum.属性配置下发.getCmdType(), propertySetRequest);
        //组装参数
        String messageId = downHandle.send(sn, message);
        if (messageId == null) {
            log.info("[端云-属性配置下发] 下发失败，参数:{}", propertySetRequest);
            return false;
        } else {
            return true;
        }

    }

    @Override
    public void dealResponse(P2cBaseResponse<String> baseResponse, Long parkId, String parkCode, String sn) {
        downHandle.dealResponse(baseResponse, parkId, P2cDownCmdEnum.属性配置下发.getCmdType());
    }
}
