package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.ItcDownHandle;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("itcPropertyGetServiceImpl")
@Slf4j
public class ItcPropertyGetServiceImpl extends AbstractService implements ResponseService<String>, DownService {
    @Autowired
    private ItcDownHandle downHandle;
    @Autowired
    private ItcCacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse<PropertyInfoRequest> send(String sn){
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        Message message = new Message(deviceInfo.getParkId(), P2cDownCmdEnum.属性获取.getCmdType(), null);
        //打开获取的开关
        redisUtils.set(RedisConstants.PROPERTY_GET_FLAG_PROFILE + sn, 1, 8L);
        //组装参数
        String messageId = downHandle.send(sn, message);
        if (messageId == null) {
            log.info("[端云-属性获取] 下发失败, sn[{}}]", sn);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        return ObjectResponse.success();

    }

    @Override
    public void dealResponse(P2cBaseResponse<String> baseResponse, Long parkId, String parkCode, String sn) {
        downHandle.dealResponse(baseResponse, parkId, ItcDownCmdEnum.属性获取.getCmdType());
    }
}
