package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.OssConfigRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcDownHandle;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.oss.OSSProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("itcOssConfigServiceImpl")
@Slf4j
public class ItcOssConfigServiceImpl extends AbstractService implements ResponseService<String>, DownService {

    @Autowired
    private OSSProperties ossProperties;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ItcDownHandle downHandle;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        return ObjectResponse.success();
    }

    public boolean send(String parkCode, String sn) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park data = byParkCode.getData();
        Long parkId = data.getId();
        OssConfigRequest ossConfigRequest = new OssConfigRequest();
        ossConfigRequest.setAccessKeyId(ossProperties.getAccessKeyId());
        ossConfigRequest.setAccessKeySecret(ossProperties.getAccessKeySecret());
        ossConfigRequest.setBucketName(ossProperties.getBucketName());
        ossConfigRequest.setEndpoint(ossProperties.getEndpoint());
        Message<OssConfigRequest> message = new Message(parkId, P2cDownCmdEnum.OSS配置下发.getCmdType(), ossConfigRequest);
        //组装参数
        String messageId = downHandle.send(sn, message);
        if (messageId == null) {
            log.info("[端云-OSS配置下发] 下发失败，参数[{}]", ossConfigRequest);
            return false;
        } else {
            return true;
        }
    }

}
