package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("itcHintServiceImpl")
@Slf4j
public class ItcHintServiceImpl extends AbstractService implements ResponseService<String> {

    @Autowired
    private ItcDownHandle downHandle;

    public ObjectResponse execute(Long parkId, String serialNumber, HintRequest hintRequest) {
        Message<HintRequest> message = new Message(parkId, ItcDownCmdEnum.屏显信息.getCmdType(), hintRequest);
        String messageId = downHandle.send(serialNumber, message);
        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> baseResponse, Long parkId, String parkCode, String serialNumber) {
        downHandle.dealResponse(baseResponse, parkId, ItcDownCmdEnum.屏显信息.getCmdType());
    }
}
