package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.FreeSpaceRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ItcFreeSpaceServiceImpl extends AbstractService implements ResponseService<String>, DownService {

    @Autowired
    private ItcDownHandle downHandle;

    public ObjectResponse send(Long parkId, String serialNumber, FreeSpaceRequest freeSpaceRequest) {
        FreeSpaceRequest request = new FreeSpaceRequest();
        BeanUtils.copyProperties(freeSpaceRequest, request);
        request.setFreeSpace(freeSpaceRequest.getShowFreeSpace());
        Message<HintRequest> message = new Message(parkId, ItcDownCmdEnum.剩余空车位.getCmdType(), request);
        String messageId = downHandle.send(serialNumber, message);
        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        return ObjectResponse.success();
    }

}
