package com.icetech.park.service.down.full.payload;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class SerialData {
    protected List<SerialDataInfo> serialData;

    public SerialData(SerialDataInfo... serialData) {
        this.serialData = Arrays.asList(serialData);
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @Accessors(chain = true)
    public static class SerialDataInfo {
        protected int serialChannel;
        protected String data;
        protected int dataLen;

        public SerialDataInfo(int serialChannel, byte[] data) {
            this.serialChannel = serialChannel;
            this.data = Base64.getEncoder().encodeToString(data);
            this.dataLen = data.length;
        }
    }
}
