package com.icetech.park.service.down.full.impl;

import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.full.WhiteListOperatorRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.FullCloudDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 名单查询下发
 * @author fangct
 */
@Slf4j
@Service
public class FullCloudWhiteListSelectServiceImpl implements ResponseService<String>, DownService<WhiteListOperatorRequest, Long> {

    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<String> execute(Long parkId, String parkCode, String plateNum, String sn) {

        WhiteListOperatorRequest whiteListOperatorRequest = new WhiteListOperatorRequest();
        whiteListOperatorRequest.setOperator_type("select");
        whiteListOperatorRequest.setPlate(plateNum);
        whiteListOperatorRequest.setSub_type("plate");

        Message<WhiteListOperatorRequest> message = new Message<>(parkId, FullCloudDownCmdEnum.白名单数据查询.getCmdType(),
                FullCloudDownCmdEnum.名单下发.getCmdType(), whiteListOperatorRequest);
        String messageId = downHandle.send(parkCode, sn, message);
        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        ObjectResponse<String> responseFromRedis = cacheHandle.getResponseFromRedis(messageId, 3000L);
        if (responseFromRedis == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3005);
        }
        String body = responseFromRedis.getData();
        return ObjectResponse.success(body);
    }
    @Override
    public void dealResponse(P2cBaseResponse<String> p2CBaseResponse, Long parkId, String parkCode, String deviceNo) {
        downHandle.dealResponse(p2CBaseResponse, parkId, FullCloudDownCmdEnum.白名单数据查询.getCmdType());
    }

}
