package com.icetech.park.service.down.full.impl;

import com.icetech.third.utils.RedisUtils;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

import static com.icetech.park.domain.constant.FullCloudConstants.FULL_DOWN_SHOW_DATE_CHANNEL;
import static com.icetech.park.domain.constant.FullCloudConstants.FULL_SHOW_STATUS;

/**
 * @author wgq
 * 定时任务执行类
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FullCloudTaskServiceImpl {

    private final RedisUtils redisUtils;

    private final FullCloudSerialDataServiceImpl fullCloudSerialDataService;

    /**
     * 定时下发屏显日期
     */
    @SneakyThrows
    public void downFreeDate() {
        Map<String, Integer> showStatusMap = redisUtils.hGetAll(FULL_SHOW_STATUS, Integer.class);
        Map<String, Map> channelFreeShowMap = redisUtils.hGetAll(FULL_DOWN_SHOW_DATE_CHANNEL, Map.class);
        showStatusMap.entrySet().removeIf(entry -> entry.getValue().equals(1));
        showStatusMap.forEach((k, v) -> {
            Map<String, Object> map = channelFreeShowMap.get(k);
            if (Objects.isNull(map)) {
                return;
            }
            Long parkId = Long.parseLong(String.valueOf(map.get("parkId")));
            String sn = String.valueOf(map.get("sn"));
            fullCloudSerialDataService.busyChangeFree(parkId, sn);
        });
    }
}
