package com.icetech.park.service.down.full.impl;

import com.alibaba.fastjson.TypeReference;
import com.icetech.basics.dao.park.OpeningDao;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.oss.OssService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.CaptureService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.FullCloudDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;


/**
 * 纯云下发接口
 *
 * @author wgq
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FullCloudSnapShotServiceImpl implements CaptureService {

    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OssService ossService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private CarOrderExitService carOrderExitService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Resource
    private OpeningDao openingDao;

    @Override
    public ObjectResponse<Void> execute(Long parkId, String parkCode, String channelId, String topic, SoftTriggerRequest extraInfo){
        String sn = cacheHandle.getSerialNumber(parkCode, channelId);
        Message<String> message = new Message<>(parkId, FullCloudDownCmdEnum.图片抓拍.getCmdType(), null);
        String messageId = downHandle.send(parkCode, sn, message, topic, JsonUtils.toString(extraInfo));
        if (messageId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003,"相机未连接");
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public ObjectResponse<String> executeAsync(Long parkId, String parkCode, String channelId){

        String deviceNo = cacheHandle.getSerialNumber(parkCode, channelId);
        Message<String> message = new Message<>(parkId, FullCloudDownCmdEnum.图片抓拍.getCmdType(), null);
        String messageId = downHandle.send(parkCode, deviceNo, message);
        if (messageId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            return ObjectResponse.success(messageId);
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        downHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.图片抓拍.getCmdType());
    }

    public void notify(String messageId, String imagePath, String sn) {
        cacheHandle.setSoftImage(messageId, imagePath);
        SendInfoRecord<SoftTriggerRequest> sendInfoRecord = redisUtils.get(RedisKeyConstants.MQ_RECORD_PREFIX + messageId,
                new TypeReference<SendInfoRecord<SoftTriggerRequest>>(){});
        log.debug("messageId:{}, object:{}, sendInfoRecord: {}", messageId, imagePath, sendInfoRecord);

        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(sn);
        Map<String, String> extraInfo = JsonUtils.parseStringMap(sendInfoRecord.getExtraInfo());
        if (extraInfo == null || extraInfo.get("biz") == null) {
            return;
        }
        String biz = extraInfo.get("biz");
        if (SoftTriggerRequest.ExtraInfoEnum.ALLOW_ENTER.val.equals(biz)) {
            CarEnterRequest entrance = buildDefaultEnterRequest(deviceInfo);
            entrance.setPlateNum(extraInfo.get("plateNum"));
            DataEnterRequest enterRequest = JsonUtils.parseObject(extraInfo.get("requestVO"), DataEnterRequest.class);
            entrance.setType(enterRequest.getType());
            entrance.setCarType(enterRequest.getCarType());
            entrance.setCarDesc(enterRequest.getSpecialCar());
            entrance.setDebug(enterRequest.isDebug());
            entrance.setEnterTime(enterRequest.getEnterTime() == null ? DateTools.unixTimestamp() : enterRequest.getEnterTime());
            entrance.setEnterWay(entrance.getPlateNum().startsWith("临")
                    ? OrderCarInfoConstant.IN_OUT_WAY_QR_CODE : OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
            entrance.setOperaUser(enterRequest.getOperaUser());
            entrance.setRemark(extraInfo.get("remark"));
            entrance.setEnterTerminal(enterRequest.getEnterTerminal());
            entrance.setMaxImage(imagePath);
            ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(entrance);
            if (ObjectResponse.isSuccess(objectResponse)) {
                //清除缓存中的上次异常记录
                cacheHandle.removeEntrace(sendInfoRecord.getParkCode(), entrance.getInandoutCode());
            }
            log.debug("topic: {}, messageId: {}", sendInfoRecord.getTopic(), messageId);
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), objectResponse);
        } else if (SoftTriggerRequest.ExtraInfoEnum.GET_CAR_INFO.val.equals(biz)) {
            EnexCarInfoBaseResponse enexCarInfoBaseResponse;
            Integer type = Integer.parseInt(extraInfo.get("type"));
            if (EnexTypeEnum.入场.getType().equals(type)) {
                //入口通道
                try {
                    enexCarInfoBaseResponse = getEntranceCarInfoResponse(imagePath);
                } catch (Exception e) {
                    log.error("软触发处理异常, e=", e);
                    return;
                }
            } else {
                //出口通道
                try {
                    CarExitRequest exit = buildDefaultExitRequest(deviceInfo);
                    exit.setMaxImage(imagePath);
                    enexCarInfoBaseResponse = getExitCarInfoResponse(deviceInfo.getParkId(), deviceInfo.getParkCode(), exit);
                } catch (Exception e) {
                    log.error("软触发处理异常, e=", e);
                    return;
                }
            }

            if (deviceInfo.getInandoutCode() != null) {
                redisUtils.set(RedisConstants.SOFT_TRIGGER_IMAGE_KEY + deviceInfo.getInandoutCode(), imagePath, 600L);
            }
            enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.纯云.getType());
            log.debug("enexCarInfoBaseResponse:{}", enexCarInfoBaseResponse);
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success(enexCarInfoBaseResponse));
        } else if (SoftTriggerRequest.ExtraInfoEnum.ALLOW_EXIT.val.equals(biz)) {
            CarExitRequest exit = buildDefaultExitRequest(deviceInfo);
            String cacheOrderNum = exit.getOrderNum();
            DataExitRequest exitRequest = JsonUtils.parseObject(extraInfo.get("requestVO"), DataExitRequest.class);
            if (cacheOrderNum != null && !exitRequest.getOrderNum().equals(cacheOrderNum)) {
                log.warn("[平台离场] 订单与缓存中的异常订单不匹配，缓存数据为:{},请求参数为:{}", exit, exitRequest);
            }
            String orderNum = exitRequest.getOrderNum();
            ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findByOrderNum(orderNum);
            if (ObjectResponse.isSuccess(orderInfoObjectResponse)){
                OrderInfo orderInfo = orderInfoObjectResponse.getData();
                Long enterTime = orderInfo.getEnterTime();
                //如果入场时间大于参数中的离场时间，则使用当前时间作为离场时间
                if (enterTime > exitRequest.getExitTime().getTime() / 1000){
                    exitRequest.setExitTime(new Date());
                }
            }
            exit.setType(exitRequest.getType());
            exit.setInandoutCode(exitRequest.getAisleCode());
            exit.setCarType(exitRequest.getCarType() != null ? exitRequest.getCarType() : exit.getCarType());
            exit.setOrderNum(orderNum == null ? cacheOrderNum : orderNum);
            exit.setPlateNum(exitRequest.getPlateNum());
            exit.setExitTime(exit.getExitTime() != null ? exit.getExitTime() : (exitRequest.getExitTime().getTime() / 1000));
            if (exitRequest.getOperAccount() != null) {
                exit.setOperAccount(exitRequest.getOperAccount());
            }
            if (exitRequest.getExitWay() != null) {
                exit.setExitWay(exitRequest.getExitWay());
            }
            if (exitRequest.getExitTerminal() != null) {
                exit.setExitTerminal(exitRequest.getExitTerminal());
            }
            ObjectResponse<Map<String, Object>> objectResponse = carOrderExitService.exit(exit);
            if (ObjectResponse.isSuccess(objectResponse)) {
                //清除缓存中的上次异常记录
                cacheHandle.removeExit(exitRequest.getParkCode(), exitRequest.getAisleCode());
                cacheHandle.removeChannelFee(exitRequest.getParkCode(), exitRequest.getAisleCode());
            }
            log.debug("topic: {}, triggerNo: {}", sendInfoRecord.getTopic(), messageId);
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), objectResponse);
        } else if (SoftTriggerRequest.ExtraInfoEnum.EXCEPTION_EXIT.val.equals(biz)) {
            CarExitRequest exit = buildDefaultExitRequest(deviceInfo);
            exit.setMaxImage(imagePath);
            exit.setPlateNum(extraInfo.get("plateNum"));
            exit.setOrderNum(extraInfo.get("orderNum"));
            exit.setOperAccount(extraInfo.get("operAccount"));
            QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(exit.getParkCode(), exit.getInandoutCode());
            if (channelFee != null){
                exit.setTotalAmount(channelFee.getTotalAmount());
                exit.setPaidAmount(channelFee.getPaidAmount());
                //String discountPrice = NumberUtils.decimalAdd(channelFee.getDiscountPrice(), channelFee.getDiscountAmount()).toString();
                exit.setDiscountAmount(channelFee.getDiscountAmount());
            }
            exit.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
            if (extraInfo.get("operAccount") != null) {
                exit.setOperAccount(extraInfo.get("operAccount"));
            }
            if (extraInfo.get("exitTerminal") != null) {
                exit.setOperAccount(extraInfo.get("exitTerminal"));
            }
            carOrderExitService.exceptionExit(exit, extraInfo.get("reasonType") == null
                    ? null : Integer.parseInt(extraInfo.get("reasonType")));
        } else if (SoftTriggerRequest.ExtraInfoEnum.CALL_VOICE_REPORT.val.equals(biz)) {
            int type = Integer.parseInt(extraInfo.get("type"));
            if (type == 2) {
                CarExitRequest exit = buildDefaultExitRequest(deviceInfo);
                exit.setMaxImage(imagePath);
                exit.setPlateNum(extraInfo.get("plateNum"));
                exit.setOrderNum(extraInfo.get("orderNum"));
                exit.setOperAccount(extraInfo.get("operAccount"));
                cacheHandle.setExit(exit.getParkCode(), exit.getInandoutCode(), exit);
            } else {
                CarEnterRequest enterRequest = buildDefaultEnterRequest(deviceInfo);
                enterRequest.setMaxImage(imagePath);
                enterRequest.setPlateNum(extraInfo.get("plateNum"));
                enterRequest.setOrderNum(extraInfo.get("orderNum"));
                enterRequest.setOperaUser(extraInfo.get("operAccount"));
                cacheHandle.setEntrance(enterRequest.getParkCode(), enterRequest.getInandoutCode(), enterRequest);
            }
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(extraInfo.get("code"), extraInfo.get("msg")));
        } else if (SoftTriggerRequest.ExtraInfoEnum.SWITCH_SNAP.val.equals(biz)) {
            int id = Integer.parseInt(extraInfo.get("id"));
            openingDao.updateImageById(id, imagePath);
        }
    }

    private CarEnterRequest buildDefaultEnterRequest(TokenDeviceVo deviceInfo) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setType(1);
        carEnterRequest.setCarType(1);
        carEnterRequest.setPlateNum(DataCommonConstants.WEI_SHI_BIE);
        carEnterRequest.setEnterTime(DateTools.unixTimestamp());
        carEnterRequest.setTriggerType(2);
        carEnterRequest.setParkId(deviceInfo.getParkId());
        carEnterRequest.setParkCode(deviceInfo.getParkCode());
        carEnterRequest.setInandoutCode(deviceInfo.getInandoutCode());
        carEnterRequest.setInandoutName(deviceInfo.getInandoutName());
        // 预生成订单号供后续流程使用
        carEnterRequest.setOrderNum(CodeTools.GenerateOrderNum());
        return carEnterRequest;
    }
    private CarExitRequest buildDefaultExitRequest(TokenDeviceVo deviceInfo) {
        CarExitRequest carExitRequest = new CarExitRequest();
        carExitRequest.setType(1);
        carExitRequest.setCarType(1);
        carExitRequest.setPlateNum(DataCommonConstants.WEI_SHI_BIE);
        carExitRequest.setExitTime(DateTools.unixTimestamp());
        carExitRequest.setTriggerType(2);
        carExitRequest.setParkId(deviceInfo.getParkId());
        carExitRequest.setParkCode(deviceInfo.getParkCode());
        carExitRequest.setInandoutCode(deviceInfo.getInandoutCode());
        carExitRequest.setInandoutName(deviceInfo.getInandoutName());
        return carExitRequest;
    }
    protected EnterCarInfoResponse getEntranceCarInfoResponse(String imagePath){
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum(DataCommonConstants.WEI_SHI_BIE);
        enterCarInfoResponse.setCarType(1);
        enterCarInfoResponse.setType(1);
        enterCarInfoResponse.setOrderNum(CodeTools.GenerateOrderNum());
        if (imagePath != null) {
            enterCarInfoResponse.setImgUrl(ossService.getImageUrl(imagePath));
            enterCarInfoResponse.setImgPath(imagePath);
        }
        return enterCarInfoResponse;
    }
    /**
     * 获取离场通道信息
     * @param parkId 车场ID
     * @param parkCode 车场编号
     * @param carExitRequest 离场请求参数
     * @return 响应
     */
    private ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest) {
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        String orderNum = carExitRequest.getOrderNum();
        exitCarInfoResponse.setExitNum(carExitRequest.getPlateNum());
        exitCarInfoResponse.setCarType(carExitRequest.getCarType());
        exitCarInfoResponse.setType(carExitRequest.getType());
        if (StringUtils.isNotBlank(orderNum)){
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
            if (byOrderInfo.getCode().equals(CodeConstants.SUCCESS)){
                OrderInfo data = byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
            exitCarInfoResponse.setOrderNum(carExitRequest.getOrderNum());
        }else{
            String plateNum = carExitRequest.getPlateNum();
            ObjectResponse<OrderInfo> byOrderInfo = orderService.findInPark(plateNum, parkCode);
            if (byOrderInfo.getCode().equals(CodeConstants.SUCCESS)){
                OrderInfo data = byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setOrderNum(data.getOrderNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
        }
        Long exitTime = carExitRequest.getExitTime();
        if (exitTime != null){
            exitCarInfoResponse.setExitTime(new Date(exitTime * 1000L));
        }else{
            //离场时间默认为当前时间
            exitCarInfoResponse.setExitTime(new Date());
        }
        String maxImage = carExitRequest.getMaxImage();
        if (maxImage != null){
            exitCarInfoResponse.setImgUrl(ossService.getImageUrl(maxImage));
            exitCarInfoResponse.setImgPath(maxImage);
        }
        return exitCarInfoResponse;
    }

}
