package com.icetech.park.service.down.full.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.p2c.ChannelRulesRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.itc.impl.ItcPropertySetServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcCacheHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.THREE;

@Service
@Slf4j
public class FullCloudChannelModifyServiceImpl extends AbstractConfigDownService implements ResponseService<String>, DownService<ChannelRulesRequest, Void> {
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ItcPropertySetServiceImpl itcPropertySetService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode){
        ParkConfig parkConfig = parkService.getParkConfig(sendRequest.getParkId()).getData();
        ObjectResponse<ParkInoutdevice> inoutDeviceResponse = parkService.getInoutDeviceById(sendRequest.getServiceId());
        if (!ObjectResponse.isSuccess(inoutDeviceResponse)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(THREE, "出入口通道未找到"));
        }
        ParkInoutdevice parkInoutdevice = inoutDeviceResponse.getData();
        String serialNumber = cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
        if (serialNumber == null){
            throw new ResponseBodyException(CodeConstants.ERROR_406, "无需下发");
        }
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(serialNumber);
        if (deviceInfo == null) {
            throw new ResponseBodyException(CodeConstants.ERROR_406, "无需下发");
        }
        Integer inandoutType = deviceInfo.getInandoutType();
        if (!parkInoutdevice.getInandoutType().equals(inandoutType)
                || !parkInoutdevice.getInandoutName().equals(deviceInfo.getInandoutName())
                || !parkInoutdevice.getRegionId().equals(deviceInfo.getRegionId())) {
            deviceInfo.setInandoutType(parkInoutdevice.getInandoutType());
            deviceInfo.setInandoutName(parkInoutdevice.getInandoutName());
            deviceInfo.setRegionId(parkInoutdevice.getRegionId());
            cacheHandle.updateDeviceInfo(serialNumber, deviceInfo);
        }
        String itcSn = itcCacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
        if (itcSn == null){
            throw new ResponseBodyException(CodeConstants.ERROR_406, "无需下发");
        }
        TokenDeviceVo itcDev = itcCacheHandle.getDeviceInfo(itcSn);
        if (itcDev == null) {
            throw new ResponseBodyException(CodeConstants.ERROR_406, "无需下发");
        }
        //通道类型不匹配时下发更新
        if (itcDev.getInandoutType().equals(parkInoutdevice.getInandoutType())) {
            throw new ResponseBodyException(CodeConstants.ERROR_406, "无需下发");
        }
        //区域ID不匹配时下发更新
        if (itcDev.getRegionId().equals(parkInoutdevice.getRegionId())) {
            throw new ResponseBodyException(CodeConstants.ERROR_406, "无需下发");
        }
        itcDev.setInandoutType(parkInoutdevice.getInandoutType());
        itcDev.setInandoutName(parkInoutdevice.getInandoutName());
        itcDev.setRegionId(parkInoutdevice.getRegionId());
        itcCacheHandle.updateDeviceInfo(itcSn, itcDev);
        com.icetech.cloudcenter.domain.request.itc.PropertySetRequest itcPsq = new com.icetech.cloudcenter.domain.request.itc.PropertySetRequest();
        itcPsq.setEnexType(parkInoutdevice.getInandoutType());
        if (parkConfig.getCarenexTimelong() != null) {
            itcPsq.setRetentionAlarm(1);
            itcPsq.setRetentionTimeThreshold(
                    NumberUtils.toPrimitive(parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60);
        }
        itcPropertySetService.send(itcPsq, itcSn);
        throw new ResponseBodyException(CodeConstants.ERROR_406, "无需下发");
    }
}
