package com.icetech.park.service.down.full.impl;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.full.WhiteListOperatorRequest;
import com.icetech.cloudcenter.domain.request.p2c.BlacklistRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.full.FullCloudSendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.FullCloudDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.icetech.basics.constants.TextConstant.ERROR_410;

@Service
@Slf4j
public class FullCloudBlacklistServiceImpl extends AbstractService implements ResponseService<String>, DownService<List<BlacklistRequest>, Void> {

    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private BlacklistService blacklistService;
    @Autowired
    private FullCloudSendMsgServiceImpl sendMsgService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode){
        sendRequest.setReqServiceType(FullCloudDownCmdEnum.名单下发.getCmdType());
        ObjectResponse<Blacklist> blacklistResponse = blacklistService.getById(sendRequest.getServiceId());
        if (!ObjectResponse.isSuccess(blacklistResponse)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TextConstant.THREE, "黑名单数据不存在"));
        }
        ObjectResponse.notError(blacklistResponse);
        Blacklist blacklist = blacklistResponse.getData();

        WhiteListOperatorRequest whiteListOperatorRequest = new WhiteListOperatorRequest();
        WhiteListOperatorRequest.DldbRec dldbRec = new WhiteListOperatorRequest.DldbRec();
        //黑名单车辆删除，3表示可进可出
        if (blacklist.getType() == 3 || blacklist.getStatus() == 1){
            whiteListOperatorRequest.setOperator_type("delete");
            whiteListOperatorRequest.setPlate(blacklist.getPlate());
            return sendMsgService.send2Park(sendRequest, parkCode, whiteListOperatorRequest);
        }else{
            List<WhiteListOperatorRequest.DldbRec> dldbRecList = new ArrayList<>();
            whiteListOperatorRequest.setOperator_type("update_or_add");
            dldbRec.setPlate(blacklist.getPlate());
            dldbRec.setIndex(blacklist.getId());
            dldbRec.setCustomer_id(blacklist.getId());
            dldbRec.setCreate_time(blacklist.getCreateTime());
            dldbRec.setEnable(1);
            dldbRec.setTime_seg_enable(0);
            dldbRec.setNeed_alarm(1);
            dldbRecList.add(dldbRec);
            whiteListOperatorRequest.setDldb_rec(dldbRecList);
            return sendMsgService.send2Park(sendRequest, parkCode, whiteListOperatorRequest);
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        downHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.黑名单下发.getCmdType());
    }

}
