package com.icetech.park.service.down.full.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.FreeSpaceSyncService;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

import static com.icetech.park.domain.constant.FullCloudConstants.FULL_BUSY_HINT;
import static com.icetech.park.domain.constant.FullCloudConstants.FULL_SHOW_STATUS;

/**
 * 纯云下发接口
 *
 * @author fangct
 */
@Slf4j
@Service
public class FreeSpaceShowServiceImpl implements FreeSpaceSyncService {

    @Autowired
    private FullCloudSerialDataServiceImpl fullDownSerialDataService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private LedService ledService;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse<Void> send2Park(SendRequest sendRequest, Long parkId, String parkCode) {
        ObjectResponse<List<ParkInoutdevice>> listResponse = parkService.getAllChannel(parkId);
        ObjectResponse.notError(listResponse);
        List<ParkInoutdevice> inOutDeviceList = listResponse.getData();
        execute(parkId, parkCode, inOutDeviceList);
        return ObjectResponse.success();
    }

    @Override
    public void send2Region(SendRequest sendRequest, Long parkId, String parkCode, Long regionId) {
        ObjectResponse<List<ParkInoutdevice>> listResponse = parkService.getAllChannel(parkId);
        ObjectResponse.notError(listResponse);
        List<ParkInoutdevice> inOutDeviceList = listResponse.getData().stream().filter(inoutdevice ->
                inoutdevice.getRegionId() != null && inoutdevice.getRegionId().equals(regionId)).collect(Collectors.toList());
        execute(parkId, parkCode, inOutDeviceList);
    }

    private void execute(Long parkId, String parkCode, List<ParkInoutdevice> inOutDeviceList) {
        for (ParkInoutdevice inoutdevice : inOutDeviceList) {
            Integer inandoutType = inoutdevice.getInandoutType();
            ObjectResponse<LedShowDto> ledVoObjectResponse;
            if (inandoutType == 1) {
                ledVoObjectResponse = ledService.getLedShowByType(inoutdevice.getId(), LedShow.DisplayTypeEnum.入口空闲显示.type);
            } else {
                ledVoObjectResponse = ledService.getLedShowByType(inoutdevice.getId(), LedShow.DisplayTypeEnum.出口空闲显示.type);
            }
            LedShowDto ledShowDto = ledVoObjectResponse.getData();
            if (ledShowDto == null) {
                continue;
            }
            if (!ledShowDto.getContent().contains("{3}")) {
                log.info("未配置空车位显示, 跳过下发[{}]", inoutdevice.getInandoutCode());
                continue;
            }

            try {
                String serialNumber = cacheHandle.getSerialNumber(parkCode, inoutdevice.getInandoutCode());
                //判断是否在繁忙状态，如果是，则跳过
                Integer status = redisUtils.hGet(FULL_SHOW_STATUS, String.valueOf(inoutdevice.getId()), Integer.class);
                boolean busyStatus = redisUtils.exists(FULL_BUSY_HINT + serialNumber);
                if (status == null || status == 0 || !busyStatus) {
                    fullDownSerialDataService.busyChangeFree(parkId, serialNumber);
                }
            } catch (ResponseBodyException e) {
                log.warn("设备不在线");
            }
            //下发给对讲立柱
            //downItc2Channel(parkId, parkCode, inoutdevice.getInandoutCode(), freeSpaceRequest);
        }
    }
}