package com.icetech.park.service.down.full.controlcard.vertical_2x8;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 方控语音控制卡(2x8标准竖屏)串口协议指令类型
 *
 * @version 20200725
 */
@Getter
@AllArgsConstructor
public enum SzfkznCmd {
    /** 查询 */
    QUERY((byte) 0x01, "查询", 0),
    /** 设置时间 */
    SET_TIME((byte) 0x10, "设置时间", 6),
    /** 取消临显 */
    CANCEL_TMP_SHOW((byte) 0x21, "取消临显", 1),
    /** 语音播放 */
    PLAY_AUDIO((byte) 0x22, "语音播放", 100),
    /** 加载广告内容 */
    LOAD_AD((byte) 0x25, "加载广告内容", 63),
    /** 临显内容 */
    TMP_SHOW((byte) 0x27, "临显内容", 63),
    /** 二维码显示 */
    SHOW_QRCODE((byte) 0x28, "二维码显示", 199),
    /** 设置勿扰音量 */
    SET_DND_VOLUME((byte) 0x56, "设置勿扰音量", 6),
    /** 设置音量 */
    SET_VOLUME((byte) 0xF0, "设置音量", 1),
    /** 万能语音播放 */
    PLAY_AUDIO_TTS((byte) 0xFD, "万能语音播放", 1),
    ;
    private final byte cmd;
    private final String desc;
    private final int maxLen;
}
