package com.icetech.park.service.down.full.controlcard.vertical_2x8;

import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.down.TagProcessor;
import com.icetech.park.service.down.full.controlcard.IControlCardTypeBuilder;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *  方控控制卡
 * @author fangct
 */
@Slf4j
public class FangKongCardService implements IControlCardTypeBuilder {

    @Override
    public List<byte[]> initControlCard(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime, int tts) {
        return buildSetVolume(volume, enable, quietVolume, startTime, endTime);
    }

    @Override
    public List<byte[]> buildSetVolume(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime) {
        List<byte[]> list = new ArrayList<>();
        //开启勿扰模式
        if (enable) {
            byte[] bytes = SzfkznBuilder.buildSetDNDVolume(enable, Math.min(volume, 9), startTime, endTime);
            list.add(bytes);
        }
        byte[] bytes = SzfkznBuilder.buildSetVolume(Math.min(volume, 9));
        list.add(bytes);
        return list;
    }

    @Override
    public byte[] buildSayByte(String say) {
        byte[] sayByte = new byte[0];
        if (StringUtils.isNotBlank(say)) {
            // 正则表达式匹配标签
            Pattern pattern = Pattern.compile("^<.*>$");
            Matcher matcher = pattern.matcher(say);
            if (matcher.matches()) {
                // 标签处理
                sayByte = SzfkznBuilder.buildPlayAudio(TagProcessor.processTags(say));
            } else {
                // TTS文本转换
                sayByte = SzfkznBuilder.buildPlayAudioTTS(say);
            }
        }
        return sayByte;
    }

    @Override
    public List<byte[]> buildShowBytes(String ledColors, int ledRestoreDefaultTime, HintRequest hintRequest, boolean busyStatus) {
        List<byte[]> showData = new ArrayList<>();
        // 检查显示内容是否为空
        if (StringUtils.isBlank(hintRequest.getShow())) {
            log.info("屏显为空");
            return showData;
        }
        // 获取颜色配置和 LED 配置
        String[] colors = ledColors.split("/");
        //包含二维码
        if (hintRequest.getShowType() == 2 || hintRequest.getShowType() == 3) {
            processShowAndQrCode(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        } else {
            processShowTexts(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        }
        return showData;
    }

    /**
     * 处理显示内容和二维码
     *
     * @param hintRequest 提示请求
     * @param busyStatus  繁忙状态
     * @param showData    显示数据列表
     * @param colors      颜色数组
     * @param ledRestoreDefaultTime   LED 配置
     */
    private void processShowAndQrCode(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        if (hintRequest.getShow().contains("|")) {
            String[] shows = hintRequest.getShow().split("\\|");
            String showText = shows[0].replace("/", "");
            String qrCode = shows[1];
            // 屏显数据
            byte[] showBytes = buildShowBytes(busyStatus, 4, ledRestoreDefaultTime, Integer.parseInt(colors[1]), showText);
            showData.add(showBytes);
            // 二维码展示
            byte[] qrBytes = SzfkznBuilder.buildShowQrcode(2, ledRestoreDefaultTime, Integer.parseInt(colors[1]), qrCode);
            showData.add(qrBytes);
        } else {
            byte[] qrBytes = SzfkznBuilder.buildShowQrcode(2, ledRestoreDefaultTime, Integer.parseInt(colors[0]), hintRequest.getShow());
            showData.add(qrBytes);
        }
    }

    /**
     * 处理纯文本显示内容
     *
     * @param hintRequest 提示请求
     * @param busyStatus  繁忙状态
     * @param showData    显示数据列表
     * @param colors      颜色数组
     * @param ledRestoreDefaultTime   恢复空闲的时间
     */
    private void processShowTexts(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        String[] showTexts = hintRequest.getShow().split("/");
        for (int i = 0; i < showTexts.length; i++) {
            String text = showTexts[i];
            byte[] showBytes = buildShowBytes(busyStatus, i + 1, ledRestoreDefaultTime, Integer.parseInt(colors[i]), text);
            showData.add(showBytes);
        }
    }

    /**
     * 构建显示字节数组
     *
     * @param busyStatus 繁忙状态
     * @param index      显示索引
     * @param ledRestoreDefaultTime  恢复空闲的时间
     * @param color      颜色值
     * @param showText   显示文本
     * @return 显示字节数组
     */
    private byte[] buildShowBytes(boolean busyStatus, int index, int ledRestoreDefaultTime, int color, String showText) {
        int displayTime = busyStatus ? ledRestoreDefaultTime + 3 : 0;
        return SzfkznBuilder.buildTmpShow(index, displayTime, color, 1, showText);
    }

}
