package com.icetech.park.service.down.full.controlcard.vertical_2x8;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

@Getter
@AllArgsConstructor
public enum AudioCode {
    /** 欢迎光临 自定义 */
    _1("欢迎光临", new byte[]{(byte) 0x1}),
    /** 一路平安 自定义 */
    _2("一路平安", new byte[]{(byte) 0x2}),
    /** 请等待人工确认 自定义 */
    _3("请等待人工确认", new byte[]{(byte) 0x3}),
    /** 余额不足 自定义 */
    _4("余额不足", new byte[]{(byte) 0x4}),
    /** 此车已进场 自定义 */
    _5("此车已进场", new byte[]{(byte) 0x5}),
    /** 此车已出场 自定义 */
    _6("此车已出场", new byte[]{(byte) 0x6}),
    /** 此车无权限 自定义 */
    _7("此车无权限", new byte[]{(byte) 0x7}),
    /** 此车已过期 自定义 */
    _8("此车已过期", new byte[]{(byte) 0x8}),
    /** 此车黑名单 自定义 */
    _9("此车黑名单", new byte[]{(byte) 0x9}),
    /** 车位已满 自定义 */
    _10("车位已满", new byte[]{(byte) 0xA}),
    /** 请缴费 自定义 */
    _11("请缴费", new byte[]{(byte) 0xB}),
    /** 有效期 自定义 */
    _12("有效期", new byte[]{(byte) 0xC}),
    /** 音量 自定义 */
    _13("音量", new byte[]{(byte) 0xD}),
    /** 此卡 自定义 */
    _14("此卡", new byte[]{(byte) 0xE}),
    /** 已过期 自定义 */
    _15("已过期", new byte[]{(byte) 0xF}),
    /** 无效 自定义 */
    _16("无效", new byte[]{(byte) 0x10}),
    /** 有效 自定义 */
    _17("有效", new byte[]{(byte) 0x11}),
    /** 有效期 自定义 */
    _18("有效期", new byte[]{(byte) 0x12}),
    /** 此车 自定义 */
    _19("此车", new byte[]{(byte) 0x13}),
    /** 请入场停车 自定义 */
    _20("请入场停车", new byte[]{(byte) 0x14}),
    /** 黑名单 自定义 */
    _21("黑名单", new byte[]{(byte) 0x15}),
    /** 记录 自定义 */
    _22("记录", new byte[]{(byte) 0x16}),
    /** 下载 自定义 */
    _23("下载", new byte[]{(byte) 0x17}),
    /** 成功 自定义 */
    _24("成功", new byte[]{(byte) 0x18}),
    /** 失败 自定义 */
    _25("失败", new byte[]{(byte) 0x19}),
    /** 已进场 自定义 */
    _26("已进场", new byte[]{(byte) 0x1A}),
    /** 已出场 自定义 */
    _27("已出场", new byte[]{(byte) 0x1B}),
    /** 无权限 自定义 */
    _28("无权限", new byte[]{(byte) 0x1C}),
    /** 删除 自定义 */
    _29("删除", new byte[]{(byte) 0x1D}),
    /** 请等待 自定义 */
    _30("请等待", new byte[]{(byte) 0x1E}),
    /** 人工确认 自定义 */
    _31("人工确认", new byte[]{(byte) 0x1F}),
    /** 亲情车 自定义 */
    _32("亲情车", new byte[]{(byte) 0x20}),
    /** 临时车 自定义 */
    _33("临时车", new byte[]{(byte) 0x21}),
    /** 月租车 自定义 */
    _34("月租车", new byte[]{(byte) 0x22}),
    /** 储值车 自定义 */
    _35("储值车", new byte[]{(byte) 0x23}),
    /** 免费车 自定义 */
    _36("免费车", new byte[]{(byte) 0x24}),
    /** 未派车 自定义 */
    _37("未派车", new byte[]{(byte) 0x25}),
    /** 谢谢 自定义 */
    _38("谢谢", new byte[]{(byte) 0x26}),
    /** 欢迎回家 自定义 */
    _39("欢迎回家", new byte[]{(byte) 0x27}),
    /** 请通行 自定义 */
    _40("请通行", new byte[]{(byte) 0x28}),
    /** 未授权 自定义 */
    _41("未授权", new byte[]{(byte) 0x29}),
    /** 已挂失 自定义 */
    _42("已挂失", new byte[]{(byte) 0x2A}),
    /** 禁止通行 自定义 */
    _43("禁止通行", new byte[]{(byte) 0x2B}),
    /** 扣款 自定义 */
    _44("扣款", new byte[]{(byte) 0x2C}),
    /** 金额 自定义 */
    _45("金额", new byte[]{(byte) 0x2D}),
    /** 停车 自定义 */
    _46("停车", new byte[]{(byte) 0x2E}),
    /** 小时 自定义 */
    _47("小时", new byte[]{(byte) 0x2F}),

    /** 0 ASCII码 */
    _48("0", new byte[]{(byte) 0x30}),
    /** 1 ASCII码 */
    _49("1", new byte[]{(byte) 0x31}),
    /** 2 ASCII码 */
    _50("2", new byte[]{(byte) 0x32}),
    /** 3 ASCII码 */
    _51("3", new byte[]{(byte) 0x33}),
    /** 4 ASCII码 */
    _52("4", new byte[]{(byte) 0x34}),
    /** 5 ASCII码 */
    _53("5", new byte[]{(byte) 0x35}),
    /** 6 ASCII码 */
    _54("6", new byte[]{(byte) 0x36}),
    /** 7 ASCII码 */
    _55("7", new byte[]{(byte) 0x37}),
    /** 8 ASCII码 */
    _56("8", new byte[]{(byte) 0x38}),
    /** 9 ASCII码 */
    _57("9", new byte[]{(byte) 0x39}),
    /** 节日 自定义 */
    _58("节日", new byte[]{(byte) 0x3A}),
    /** 快乐 自定义 */
    _59("快乐", new byte[]{(byte) 0x3B}),
    /** 新年 自定义 */
    _60("新年", new byte[]{(byte) 0x3C}),
    /** 剩余 自定义 V1.4.0新增 */
    _61("剩余", new byte[]{(byte) 0x3D}),
    /** 读卡 自定义 V1.4.0新增 */
    _62("读卡", new byte[]{(byte) 0x3E}),
    /** 车卡不符 自定义 V1.4.0新增 */
    _63("车卡不符", new byte[]{(byte) 0x3F}),
    _64(" ", new byte[]{(byte) 0x40}),
    /** A ASCII码 */
    _65("A", new byte[]{(byte) 0x41}),
    /** B ASCII码 */
    _66("B", new byte[]{(byte) 0x42}),
    /** C ASCII码 */
    _67("C", new byte[]{(byte) 0x43}),
    /** D ASCII码 */
    _68("D", new byte[]{(byte) 0x44}),
    /** E ASCII码 */
    _69("E", new byte[]{(byte) 0x45}),
    /** F ASCII码 */
    _70("F", new byte[]{(byte) 0x46}),
    /** G ASCII码 */
    _71("G", new byte[]{(byte) 0x47}),
    /** H ASCII码 */
    _72("H", new byte[]{(byte) 0x48}),
    /** I ASCII码 */
    _73("I", new byte[]{(byte) 0x49}),
    /** J ASCII码 */
    _74("J", new byte[]{(byte) 0x4A}),
    /** K ASCII码 */
    _75("K", new byte[]{(byte) 0x4B}),
    /** L ASCII码 */
    _76("L", new byte[]{(byte) 0x4C}),
    /** M ASCII码 */
    _77("M", new byte[]{(byte) 0x4D}),
    /** N ASCII码 */
    _78("N", new byte[]{(byte) 0x4E}),
    /** O ASCII码 */
    _79("O", new byte[]{(byte) 0x4F}),
    /** P ASCII码 */
    _80("P", new byte[]{(byte) 0x50}),
    /** Q ASCII码 */
    _81("Q", new byte[]{(byte) 0x51}),
    /** R ASCII码 */
    _82("R", new byte[]{(byte) 0x52}),
    /** S ASCII码 */
    _83("S", new byte[]{(byte) 0x53}),
    /** T ASCII码 */
    _84("T", new byte[]{(byte) 0x54}),
    /** U ASCII码 */
    _85("U", new byte[]{(byte) 0x55}),
    /** V ASCII码 */
    _86("V", new byte[]{(byte) 0x56}),
    /** W ASCII码 */
    _87("W", new byte[]{(byte) 0x57}),
    /** X ASCII码 */
    _88("X", new byte[]{(byte) 0x58}),
    /** Y ASCII码 */
    _89("Y", new byte[]{(byte) 0x59}),
    /** Z ASCII码 */
    _90("Z", new byte[]{(byte) 0x5A}),

    /** 健康 自定义 V1.7.0新增 */
    _91("健康", new byte[]{(byte) 0x5B}),
    /** 入场 自定义 V1.7.0新增 */
    _92("入场", new byte[]{(byte) 0x5C}),
    /** 欢迎 自定义 V1.7.0新增 */
    _93("欢迎", new byte[]{(byte) 0x5D}),
    /** 泊车 自定义 V1.7.0新增 */
    _94("泊车", new byte[]{(byte) 0x5E}),
    /** 一路顺风 自定义 V1.7.0新增 */
    _95("一路顺风", new byte[]{(byte) 0x5F}),
    /** 下次 自定义 V1.7.0新增 */
    _96("下次", new byte[]{(byte) 0x60}),
    /** 光临 自定义 V1.7.0新增 */
    _97("光临", new byte[]{(byte) 0x61}),
    /** 再次 自定义 V1.7.0新增 */
    _98("再次", new byte[]{(byte) 0x62}),
    /** 出入平安 自定义 V1.7.0新增 */
    _99("出入平安", new byte[]{(byte) 0x63}),
    /** 该时段 自定义 V1.7.0新增 */
    _100("该时段", new byte[]{(byte) 0x64}),
    /** 不允许进入 自定义 V1.7.0新增 */
    _101("不允许进入", new byte[]{(byte) 0x65}),
    /** 内部车场 自定义 V1.7.0新增 */
    _102("内部车场", new byte[]{(byte) 0x66}),
    /** 正在计费 自定义 V1.7.0新增 */
    _103("正在计费", new byte[]{(byte) 0x67}),
    /** 直接放行 自定义 V1.7.0新增 */
    _104("直接放行", new byte[]{(byte) 0x68}),
    /** 管控车辆 自定义 V1.7.0新增 */
    _105("管控车辆", new byte[]{(byte) 0x69}),
    /** 缴费 自定义 V1.7.0新增 */
    _106("缴费", new byte[]{(byte) 0x6A}),
    /** 中心 自定义 V1.7.0新增 */
    _107("中心", new byte[]{(byte) 0x6B}),
    /** 岗亭 自定义 V1.7.0新增 */
    _108("岗亭", new byte[]{(byte) 0x6C}),
    /** 超过 自定义 V1.7.0新增 */
    _109("超过", new byte[]{(byte) 0x6D}),
    /** 离场 自定义 V1.7.0新增 */
    _110("离场", new byte[]{(byte) 0x6E}),
    /** 限时 自定义 V1.7.0新增 */
    _111("限时", new byte[]{(byte) 0x6F}),
    /** 重新 自定义 V1.7.0新增 */
    _112("重新", new byte[]{(byte) 0x70}),
    /** 快递 自定义 V1.7.0新增 */
    _113("快递", new byte[]{(byte) 0x71}),
    /** 管理处 自定义 V1.7.0新增 */
    _114("管理处", new byte[]{(byte) 0x72}),
    /** 及时 自定义 V1.7.0新增 */
    _115("及时", new byte[]{(byte) 0x73}),
    /** 缴纳 自定义 V1.7.0新增 */
    _116("缴纳", new byte[]{(byte) 0x74}),
    /** 管理费 自定义 V1.7.0新增 */
    _117("管理费", new byte[]{(byte) 0x75}),
    /** 水电费 自定义 V1.7.0新增 */
    _118("水电费", new byte[]{(byte) 0x76}),
    /** 春节 自定义 V1.7.0新增 */
    _119("春节", new byte[]{(byte) 0x77}),
    /** 中秋节 自定义 V1.7.0新增 */
    _120("中秋节", new byte[]{(byte) 0x78}),
    /** 国庆节 自定义 V1.7.0新增 */
    _121("国庆节", new byte[]{(byte) 0x79}),
    /** 劳动节 自定义 V1.7.0新增 */
    _122("劳动节", new byte[]{(byte) 0x7A}),
    /** 圣诞节 自定义 V1.7.0新增 */
    _123("圣诞节", new byte[]{(byte) 0x7B}),
    /** 元旦 自定义 V1.7.0新增 */
    _124("元旦", new byte[]{(byte) 0x7C}),
    /** 微信 自定义 V1.7.0新增 */
    _125("微信", new byte[]{(byte) 0x7D}),
    /** 支付 自定义 V1.7.0新增 */
    _126("支付", new byte[]{(byte) 0x7E}),
    /** 时租车 自定义 V1.7.0新增 */
    _127("时租车", new byte[]{(byte) 0x7F, (byte) 0x00}),
    /** 月临车 自定义 V1.7.0新增 */
    _128("月临车", new byte[]{(byte) 0x7F, (byte) 0x01}),
    /** 非法开闸 自定义 V1.7.0新增 */
    _129("非法开闸", new byte[]{(byte) 0x7F, (byte) 0x02}),
    /** 交费处 自定义 V1.7.0新增 */
    _130("交费处", new byte[]{(byte) 0x7F, (byte) 0x03}),
    /** 未解锁 自定义 V1.8.4 */
    _131("未解锁", new byte[]{(byte) 0x7F, (byte) 0x04}),
    /** 匹配 自定义 */
    _132("匹配", new byte[]{(byte) 0x7F, (byte) 0x05}),
    /** 场内 自定义 */
    _133("场内", new byte[]{(byte) 0x7F, (byte) 0x06}),
    /** 通道 自定义 */
    _134("通道", new byte[]{(byte) 0x7F, (byte) 0x07}),
    /** 按临时车计费 自定义 */
    _135("按临时车计费", new byte[]{(byte) 0x7F, (byte) 0x08}),
    /** good luck 自定义 */
    _136("good luck", new byte[]{(byte) 0x7F, (byte) 0x09}),
    /** welcome 自定义 */
    _137("welcome", new byte[]{(byte) 0x7F, (byte) 0x0A}),
    /** 贵宾车 自定义 */
    _138("贵宾车", new byte[]{(byte) 0x7F, (byte) 0x0B}),
    /** 内部车 自定义 */
    _139("内部车", new byte[]{(byte) 0x7F, (byte) 0x0C}),
    /** 业主车 自定义 */
    _140("业主车", new byte[]{(byte) 0x7F, (byte) 0x0D}),
    /** 员工车 自定义 */
    _141("员工车", new byte[]{(byte) 0x7F, (byte) 0x0E}),
    /** zero 自定义 */
    _142("zero", new byte[]{(byte) 0x7F, (byte) 0x0F}),
    /** one 自定义 */
    _143("one", new byte[]{(byte) 0x7F, (byte) 0x10}),
    /** two 自定义 */
    _144("two", new byte[]{(byte) 0x7F, (byte) 0x11}),
    /** three 自定义 */
    _145("three", new byte[]{(byte) 0x7F, (byte) 0x12}),
    /** four 自定义 */
    _146("four", new byte[]{(byte) 0x7F, (byte) 0x13}),
    /** five 自定义 */
    _147("five", new byte[]{(byte) 0x7F, (byte) 0x14}),
    /** six 自定义 */
    _148("six", new byte[]{(byte) 0x7F, (byte) 0x15}),
    /** seven 自定义 */
    _149("seven", new byte[]{(byte) 0x7F, (byte) 0x16}),
    /** eight 自定义 */
    _150("eight", new byte[]{(byte) 0x7F, (byte) 0x17}),
    /** nine 自定义 */
    _151("nine", new byte[]{(byte) 0x7F, (byte) 0x18}),
    /** 无牌车 自定义 V2.0.A支持 */
    _152("无牌车", new byte[]{(byte) 0x7F, (byte) 0x19}),
    /** 民航 自定义 V2.0.A支持 */
    _153("民航", new byte[]{(byte) 0x7F, (byte) 0x1A}),
    /** 扫码 自定义 V2.0.A支持 */
    _154("扫码", new byte[]{(byte) 0x7F, (byte) 0x1B}),

    // 155
    /** 十 GBK码 */
    _156("十", new byte[]{(byte) 0xca, (byte) 0xae}),
    /** 百 GBK码 */
    _157("百", new byte[]{(byte) 0xb0, (byte) 0xd9}),
    /** 千 GBK码 */
    _158("千", new byte[]{(byte) 0xc7, (byte) 0xa7}),
    /** 万 GBK码 */
    _159("万", new byte[]{(byte) 0xcd, (byte) 0xf2}),
    /** 年 GBK码 */
    _160("年", new byte[]{(byte) 0xc4, (byte) 0xea}),
    /** 月 GBK码 */
    _161("月", new byte[]{(byte) 0xd4, (byte) 0xc2}),
    /** 日 GBK码 */
    _162("日", new byte[]{(byte) 0xc8, (byte) 0xd5}),
    /** 天 GBK码 */
    _163("天", new byte[]{(byte) 0xcc, (byte) 0xec}),
    /** 条 GBK码 */
    _164("条", new byte[]{(byte) 0xcc, (byte) 0xf5}),
    /** 京 GBK码 */
    _165("京", new byte[]{(byte) 0xbe, (byte) 0xa9}),
    /** 黑 GBK码 */
    _166("黑", new byte[]{(byte) 0xba, (byte) 0xda}),
    /** 吉 GBK码 */
    _167("吉", new byte[]{(byte) 0xbc, (byte) 0xaa}),
    /** 辽 GBK码 */
    _168("辽", new byte[]{(byte) 0xc1, (byte) 0xc9}),
    /** 苏 GBK码 */
    _169("苏", new byte[]{(byte) 0xcb, (byte) 0xd5}),
    /** 鲁 GBK码 */
    _170("鲁", new byte[]{(byte) 0xc2, (byte) 0xb3}),
    /** 皖 GBK码 */
    _171("皖", new byte[]{(byte) 0xcd, (byte) 0xee}),
    /** 冀 GBK码 */
    _172("冀", new byte[]{(byte) 0xbc, (byte) 0xbd}),
    /** 豫 GBK码 */
    _173("豫", new byte[]{(byte) 0xd4, (byte) 0xa5}),
    /** 鄂 GBK码 */
    _174("鄂", new byte[]{(byte) 0xb6, (byte) 0xf5}),
    /** 湘 GBK码 */
    _175("湘", new byte[]{(byte) 0xcf, (byte) 0xe6}),
    /** 赣 GBK码 */
    _176("赣", new byte[]{(byte) 0xb8, (byte) 0xd3}),
    /** 陕 GBK码 */
    _177("陕", new byte[]{(byte) 0xc9, (byte) 0xc2}),
    /** 晋 GBK码 */
    _178("晋", new byte[]{(byte) 0xbd, (byte) 0xfa}),
    /** 川 GBK码 */
    _179("川", new byte[]{(byte) 0xb4, (byte) 0xa8}),
    /** 青 GBK码 */
    _180("青", new byte[]{(byte) 0xc7, (byte) 0xe0}),
    /** 琼 GBK码 */
    _181("琼", new byte[]{(byte) 0xc7, (byte) 0xed}),
    /** 粤 GBK码 */
    _182("粤", new byte[]{(byte) 0xd4, (byte) 0xc1}),
    /** 浙 GBK码 */
    _183("浙", new byte[]{(byte) 0xd5, (byte) 0xe3}),
    /** 闽 GBK码 */
    _184("闽", new byte[]{(byte) 0xc3, (byte) 0xf6}),
    /** 甘 GBK码 */
    _185("甘", new byte[]{(byte) 0xb8, (byte) 0xca}),
    /** 云 GBK码 */
    _186("云", new byte[]{(byte) 0xd4, (byte) 0xc6}),
    /** 台 GBK码 */
    _187("台", new byte[]{(byte) 0xcc, (byte) 0xa8}),
    /** 贵 GBK码 */
    _188("贵", new byte[]{(byte) 0xb9, (byte) 0xf3}),
    /** 渝 GBK码 */
    _189("渝", new byte[]{(byte) 0xd3, (byte) 0xe5}),
    /** 沪 GBK码 */
    _190("沪", new byte[]{(byte) 0xbb, (byte) 0xa6}),
    /** 津 GBK码 */
    _191("津", new byte[]{(byte) 0xbd, (byte) 0xf2}),
    /** 新 GBK码 */
    _192("新", new byte[]{(byte) 0xd0, (byte) 0xc2}),
    /** 桂 GBK码 */
    _193("桂", new byte[]{(byte) 0xb9, (byte) 0xf0}),
    /** 蒙 GBK码 */
    _194("蒙", new byte[]{(byte) 0xc3, (byte) 0xc9}),
    /** 宁 GBK码 */
    _195("宁", new byte[]{(byte) 0xc4, (byte) 0xfe}),
    /** 军 GBK码 */
    _196("军", new byte[]{(byte) 0xbe, (byte) 0xfc}),
    /** 学 GBK码 */
    _197("学", new byte[]{(byte) 0xd1, (byte) 0xa7}),
    /** 警 GBK码 */
    _198("警", new byte[]{(byte) 0xbe, (byte) 0xaf}),
    /** 点 GBK码 */
    _199("点", new byte[]{(byte) 0xb5, (byte) 0xe3}),
    _199_2(".", new byte[]{(byte) 0xb5, (byte) 0xe3}),
    /** 元 GBK码 */
    _200("元", new byte[]{(byte) 0xd4, (byte) 0xaa}),
    /** 您 GBK码 */
    _201("您", new byte[]{(byte) 0xc4, (byte) 0xfa}),
    /** 好 GBK码 */
    _202("好", new byte[]{(byte) 0xba, (byte) 0xc3}),
    /** 分 GBK码 */
    _203("分", new byte[]{(byte) 0xb7, (byte) 0xd6}),
    /** 空 GBK码 */
    _204("空", new byte[]{(byte) 0xbf, (byte) 0xd5}),
    /** 海 GBK码 */
    _205("海", new byte[]{(byte) 0xba, (byte) 0xa3}),
    /** 北 GBK码 */
    _206("北", new byte[]{(byte) 0xb1, (byte) 0xb1}),
    /** 沈 GBK码 */
    _207("沈", new byte[]{(byte) 0xc9, (byte) 0xf2}),
    /** 兰 GBK码 */
    _208("兰", new byte[]{(byte) 0xc0, (byte) 0xbc}),
    /** 济 GBK码 */
    _209("济", new byte[]{(byte) 0xbc, (byte) 0xc3}),
    /** 南 GBK码 */
    _210("南", new byte[]{(byte) 0xc4, (byte) 0xcf}),
    /** 广 GBK码 */
    _211("广", new byte[]{(byte) 0xb9, (byte) 0xe3}),
    /** 成 GBK码 */
    _212("成", new byte[]{(byte) 0xb3, (byte) 0xc9}),
    /** 甲 GBK码 */
    _213("甲", new byte[]{(byte) 0xbc, (byte) 0xd7}),
    /** 乙 GBK码 */
    _214("乙", new byte[]{(byte) 0xd2, (byte) 0xd2}),
    /** 丙 GBK码 */
    _215("丙", new byte[]{(byte) 0xb1, (byte) 0xfb}),
    /** 午 GBK码 */
    _216("午", new byte[]{(byte) 0xce, (byte) 0xe7}),
    /** 未 GBK码 */
    _217("未", new byte[]{(byte) 0xce, (byte) 0xb4}),
    /** 申 GBK码 */
    _218("申", new byte[]{(byte) 0xc9, (byte) 0xea}),
    /** 庚 GBK码 */
    _219("庚", new byte[]{(byte) 0xb8, (byte) 0xfd}),
    /** 己 GBK码 */
    _220("己", new byte[]{(byte) 0xbc, (byte) 0xba}),
    /** 辛 GBK码 */
    _221("辛", new byte[]{(byte) 0xd0, (byte) 0xc1}),
    /** 壬 GBK码 */
    _222("壬", new byte[]{(byte) 0xc8, (byte) 0xc9}),
    /** 寅 GBK码 */
    _223("寅", new byte[]{(byte) 0xd2, (byte) 0xfa}),
    /** 戍 GBK码 */
    _224("戍", new byte[]{(byte) 0xca, (byte) 0xf9}),
    /** 祝 GBK码 V1.4.0新增 */
    _225("祝", new byte[]{(byte) 0xd7, (byte) 0xa3}),
    /** 藏 GBK码 V1.4.0新增 */
    _226("藏", new byte[]{(byte) 0xb2, (byte) 0xd8}),
    /** 港 GBK码 V1.4.0新增 */
    _227("港", new byte[]{(byte) 0xb8, (byte) 0xdb}),
    /** 澳 GBK码 V1.4.0新增 */
    _228("澳", new byte[]{(byte) 0xb0, (byte) 0xc4}),
    /** 领 GBK码 V1.4.0新增 */
    _229("领", new byte[]{(byte) 0xc1, (byte) 0xec}),
    /** 使 GBK码 V1.4.0新增 */
    _230("使", new byte[]{(byte) 0xca, (byte) 0xb9}),
    /** 请 GBK码 V1.7.0新增 */
    _231("请", new byte[]{(byte) 0xc7, (byte) 0xeb}),
    /** 到 GBK码 V1.7.0新增 */
    _232("到", new byte[]{(byte) 0xb5, (byte) 0xbd}),
    /** 有 GBK码 V1.7.0新增 */
    _233("有", new byte[]{(byte) 0xd3, (byte) 0xd0}),
    /** 在 GBK码 V1.7.0新增 */
    _234("在", new byte[]{(byte) 0xd4, (byte) 0xda}),
    /** 宝 GBK码 V1.7.0新增 */
    _235("宝", new byte[]{(byte) 0xb1, (byte) 0xa6}),
    /** 次 GBK码 V1.7.0新增 */
    _236("次", new byte[]{(byte) 0xb4, (byte) 0xce}),
    /** 秒 GBK码 V1.7.0新增 */
    _237("秒", new byte[]{(byte) 0xc3, (byte) 0xeb}),
    ;

    private final String ctx;
    private final byte[] code;

    private static final Map<String, AudioCode> CTX_MAP;

    static {
        CTX_MAP = new LinkedHashMap<>();
        Stream.of(AudioCode.values())
                .sorted(Comparator.<AudioCode>comparingInt(code -> code.getCtx().length()).reversed())
                .forEach(code -> CTX_MAP.put(code.getCtx(), code));
    }

    public static AudioCode resolveCode(String ctx) {
        return CTX_MAP.get(ctx);
    }
}
