package com.icetech.park.service.down.full.controlcard.dtong_lcd;

import lombok.Getter;

/**
 * Rs485通用协议V2.8指令集定义
 * @author fangct
 */
@Getter
public enum DtongLcdCmd {
    // 系统管理指令
    CONNECT((byte)0x00, 255, "连接设备"),
    MODIFY_PWD((byte)0x02, 255, "修改密码"),
    SYNC_TIME((byte)0x05, 255, "同步时间"),
    SET_TTS((byte)0x1D, 255, "设置TTS"),
    CHANGE_ADDR((byte)0x07, 255, "更改通信地址"),
    CHANGE_BAUD((byte)0x0A, 255, "更改波特率"),
    ADJUST_BRIGHT((byte)0x0C, 255, "调整显示亮度"),
    ADJUST_VOL((byte)0x0D, 255, "调整音量"),
    SET_RELAY((byte)0x0F, 255, "设置继电器状态"),
    SET_485_MODE((byte)0x1A, 255, "设置485工作模式"),
    RESTORE_FACTORY((byte)0x1E, 255, "恢复出厂设置"),

    // 语音接口指令
    PLAY_VOICE((byte)0x30, 255, "播放语音"),
    STOP_VOICE((byte)0x31, 255, "停止播放语音"),

    // 显示接口指令
    DOWNLOAD_TEMP((byte)0x62, 255, "下载临时文本"),
    DOWNLOAD_AD((byte)0x67, 255, "下载广告语"),
    SHOW_AD((byte)0x68, 255, "显示广告语"),
    MULTI_LINE((byte)0x6F, 255, "多行单包显示带语音"),

    // 扩展指令
    SET_TEMP_AUTH((byte)0xD3, 255, "配置临时车权限"),
    GET_GPS((byte)0xD4, 255, "获取GPS位置"),
    GET_INPUT((byte)0xD5, 255, "获取输入事件"),
    SET_LIGHT((byte)0xD8, 255, "设置补光灯"),
    QR_PAY((byte)0xE1, 255, "扫码支付页面"),
    SET_SPACE((byte)0xE3, 255, "设置余位"),
    QR_PAY_V2((byte)0xE5, 255, "扫码支付页面V2"),
    SET_AD_MODE((byte)0xE6, 255, "配置广告播放模式"),
    NO_PLATE_QR((byte)0xE7, 255, "无牌车扫码页面");

    /** 命令字节 */
    private final byte cmd;
    /** 数据区最大长度 */
    private final int maxLen;
    /** 命令描述 */
    private final String description;

    /** V1版本最大包长度 */
    public static final int MAX_PACKET_LENGTH = 255;
    /** V2版本最大包长度 */
    public static final int MAX_PACKET_LENGTH_V2 = 65535;

    /** 继电器通道定义 */
    public static final byte CHANNEL_TRAFFIC_LIGHT = 0x00;  // 红绿灯
    public static final byte CHANNEL_OPEN_GATE = 0x01;      // 开闸
    public static final byte CHANNEL_CLOSE_GATE = 0x02;     // 关闸
    public static final byte CHANNEL_LIGHT_AND_OPEN = (byte)0xFE; // 红绿灯和开闸同步操作

    /** 485工作模式 */
    public static final byte MODE_HALF_DUPLEX = 0x00;  // 半双工模式
    public static final byte MODE_HALF_WORK = 0x01;    // 半工模式

    /** 临时车权限 */
    public static final byte AUTH_FORBID = 0x00;      // 禁止通行
    public static final byte AUTH_ALLOW = 0x01;       // 允许通行
    public static final byte AUTH_MANUAL = 0x02;      // 人工放行
    public static final byte AUTH_NO_RIGHT = 0x03;    // 无权通行

    /** 显示模式 */
    public static final byte DISPLAY_IMMEDIATE = 0x00;    // 立即显示
    public static final byte DISPLAY_RIGHT_TO_LEFT = 0x01;// 从右向左移动
    public static final byte DISPLAY_LEFT_TO_RIGHT = 0x02;// 从左向右移动
    public static final byte DISPLAY_DOWN_TO_UP = 0x03;   // 从下向上移动
    public static final byte DISPLAY_UP_TO_DOWN = 0x04;   // 从上向下移动
    public static final byte DISPLAY_DOWN_WINDOW = 0x05;  // 向下拉窗
    public static final byte DISPLAY_UP_WINDOW = 0x06;    // 向上拉窗
    public static final byte DISPLAY_LEFT_WINDOW = 0x07;  // 向左拉窗
    public static final byte DISPLAY_RIGHT_WINDOW = 0x08; // 向右拉窗
    public static final byte DISPLAY_CHAR_BY_CHAR = 0x0D; // 逐字显示
    public static final byte DISPLAY_CONTINUOUS_LEFT = 0x15;// 连续左移

    /** 字体索引 */
    public static final byte FONT_ASCII8 = 0x00;      // ASCII8
    public static final byte FONT_ASCII10 = 0x01;     // ASCII10
    public static final byte FONT_ASCII13 = 0x02;     // ASCII13
    public static final byte FONT_SONG16 = 0x03;      // 宋体16
    public static final byte FONT_SONG24 = 0x04;      // 宋体24
    public static final byte FONT_SONG32 = 0x05;      // 宋体32
    public static final byte FONT_SONG48 = 0x06;      // 宋体48
    public static final byte FONT_SONG64 = 0x07;      // 宋体64

    /** 图标颜色 */
    public static final byte ICON_COLOR_RED = 0x00;    // 红色
    public static final byte ICON_COLOR_GREEN = 0x01;  // 绿色
    public static final byte ICON_COLOR_BLUE = 0x02;   // 蓝色
    public static final byte ICON_COLOR_YELLOW = 0x03; // 黄色
    public static final byte ICON_COLOR_CYAN = 0x04;   // 青色
    public static final byte ICON_COLOR_PURPLE = 0x05; // 紫色
    public static final byte ICON_COLOR_WHITE = 0x06;  // 白色

    DtongLcdCmd(byte cmd, int maxLen, String description) {
        this.cmd = cmd;
        this.maxLen = maxLen;
        this.description = description;
    }
}