package com.icetech.park.service.down.full.controlcard.dtong_lcd;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * Rs485通用协议V2.8预定义音频代码
* @author fangct
 */
@Getter
@AllArgsConstructor
public enum DtongLcdAudioCode {
    // 数字
    NUM_0(1, "0"),
    NUM_1(2, "1"),
    NUM_2(3, "2"),
    NUM_3(4, "3"),
    NUM_4(5, "4"),
    NUM_5(6, "5"),
    NUM_6(7, "6"),
    NUM_7(8, "7"),
    NUM_8(9, "8"),
    NUM_9(10, "9"),

    // 字母
    LETTER_A(11, "A"),
    LETTER_B(12, "B"),
    LETTER_C(13, "C"),
    LETTER_D(14, "D"),
    LETTER_E(15, "E"),
    LETTER_F(16, "F"),
    LETTER_G(17, "G"),
    LETTER_H(18, "H"),
    LETTER_I(19, "I"),
    LETTER_IP(20, "IP"),
    LETTER_J(21, "J"),
    LETTER_K(22, "K"),
    LETTER_L(23, "L"),
    LETTER_M(24, "M"),
    LETTER_N(25, "N"),
    LETTER_O(26, "O"),
    LETTER_P(27, "P"),
    LETTER_Q(28, "Q"),
    LETTER_R(29, "R"),
    LETTER_S(30, "S"),
    LETTER_T(31, "T"),
    LETTER_U(32, "U"),
    LETTER_V(33, "V"),
    LETTER_W(34, "W"),
    LETTER_X(35, "X"),
    LETTER_Y(36, "Y"),
    LETTER_Z(37, "Z"),

    // 省份简称
    AO(38, "澳"),
    BAI(39, "百"),
    BAN(40, "半"),
    BEI(41, "北"),
    CANG(42, "藏"),
    CHUAN(53, "川"),
    E(61, "鄂"),
    GAN(66, "甘"),
    GAN_2(67, "赣"),
    GANG(68, "港"),
    GUI(73, "贵"),
    GUI_2(74, "桂"),
    HAI(77, "海"),
    HEI(79, "黑"),
    HU(80, "沪"),
    JI(82, "吉"),
    JI_2(84, "己"),
    JI_3(85, "济"),
    JI_4(86, "冀"),
    JIN(89, "津"),
    JIN_2(90, "晋"),
    JING(92, "京"),
    LAN(98, "兰"),
    LIAO(100, "辽"),
    LU(104, "鲁"),
    MENG(105, "蒙"),
    MIN(108, "闽"),
    NAN(109, "南"),
    NING(113, "宁"),
    QIONG(122, "琼"),
    SHAN(128, "陕"),
    SHEN(129, "深"),
    SHEN_2(130, "沈"),
    SU(140, "苏"),
    TAI(141, "台"),
    WAN(146, "皖"),
    XIANG(154, "湘"),
    YU(164, "渝"),
    YU_2(165, "豫"),
    YUE_3(173, "粤"),
    YUN(174, "云"),
    ZHE(175, "浙"),

    // 常用词组
    WELCOME(81, "欢迎光临"),
    PLEASE_ENTER(119, "请入场停车"),
    PLEASE_PAY(118, "请交费"),
    PLEASE_PASS(120, "请通过"),
    PLEASE_SLOW(117, "请减速慢行"),
    THANK_YOU(156, "谢谢"),
    HAVE_SAFE_TRIP(159, "一路平安"),
    HAVE_GOOD_TRIP(160, "一路顺风"),
    PARKING_FULL(43, "车场已满"),
    NO_SPACE(47, "车位已满"),
    EXPIRED(48, "车已过期"),
    ALREADY_IN(49, "车已在场"),
    TEMPORARY_CAR(102, "临时车"),
    FIXED_CAR(70, "固定车"),
    MONTHLY_CAR(168, "月卡车"),
    VIP_CAR(224, "贵宾车"),
    POLICE_CAR(95, "军警车"),
    NO_PLATE(301, "无牌车"),

    // 时间相关
    YEAR(111, "年"),
    MONTH(167, "月"),
    DAY(124, "日"),
    HOUR(136, "时"),
    MINUTE(62, "分"),
    SECOND(107, "秒"),
    WEEK(311, "星期"),

    // 金额相关
    YUAN(166, "元"),
    JIAO(88, "角"),
    REMAINING_AMOUNT(133, "剩余金额"),
    PAYMENT_AMOUNT(247, "扣款金额为"),

    // 状态提示
    SUCCESS(285, "识别成功"),
    PAYMENT_SUCCESS(237, "缴费成功"),
    DEDUCTION_SUCCESS(246, "扣款成功"),
    PLEASE_WAIT(271, "请稍等"),
    PLEASE_SCAN(269, "请扫码"),
    PROCESSING(289, "收费中"),
    MANUAL_OPEN(284, "人工开闸"),
    MANUAL_CLOSE(285, "人工落闸"),
    GATE_OPENING(214, "道闸已开启"),
    GATE_CLOSING(328, "闸杆下落"),
    CALCULATING_FEE(329, "正在计费"),
    MANUAL_PROCESSING(330, "正在人工处理"),

    // 支付方式
    WECHAT(297, "微信"),
    ALIPAY(331, "支付宝"),
    UNIONPAY(316, "银联卡"),
    SCAN_TO_PAY(286, "扫码支付"),
    E_PAYMENT(314, "已电子支付"),

    // 节日祝福
    HAPPY_NEW_YEAR(309, "新年快乐"),
    HAPPY_SPRING_FESTIVAL(200, "春节快乐"),
    HAPPY_LABOR_DAY(248, "劳动节快乐"),
    HAPPY_NATIONAL_DAY(225, "国庆节快乐"),
    HAPPY_MID_AUTUMN(333, "中秋节快乐"),
    HAPPY_CHRISTMAS(287, "圣诞节快乐"),
    WISH_HEALTH(340, "祝您健康"),
    WISH_RECOVERY(341, "祝您早日康复"),

    // 补充其他常用词组
    PLATE_NUMBER(44, "车牌"),
    PLATE_NUMBER_IS(45, "车牌号为"),
    NOT_ENTERED(46, "车未入场"),
    PEACE_ENTER_EXIT(51, "出入平安"),
    STORED_VALUE_CAR(52, "储值车"),
    CAR_EXPIRY_REMAINING(54, "此车到期时间剩余"),
    CAR_AVAILABLE_DATE(55, "此车可用日期"),
    CAR_EXPIRED(56, "此车已过期"),
    TIMES(57, "次"),
    NUMBER(58, "第"),
    POINT(59, "点"),
    TON(60, "吨"),
    FEN_ZHONG(63, "分钟"),
    NEGATIVE(64, "负"),
    THIS_CAR(65, "该车"),
    GE(69, "个"),
    HANG(71, "挂"),
    GUANG_2(72, "广"),
    EXPIRED_CARS(75, "过期车辆"),
    EXPIRED_USERS(76, "过期用户"),
    HAO_2(78, "号"),
    JI_JIANG_EXPIRED(83, "即将过期"),
    JIAO_FEI_2(87, "交费"),
    JIN_ZHI_TONG(91, "禁止通行"),
    JING_3(93, "警"),
    JUN_2(94, "军"),
    AVAILABLE_DATE(96, "可用日期"),
    KONG_2(97, "空"),
    LIANG_2(99, "两"),
    LIN_2(101, "临"),
    TEMPORARY_CARS(103, "临时车辆"),
    MIAN_2(106, "免"),
    MIAO_2(107, "秒"),
    NAN_2(109, "南"),
    INTERNAL_CAR(110, "内部车"),
    NIN_HAO(112, "您好"),
    NING_2(113, "宁"),
    NONG_2(114, "农"),
    QIAN_2(115, "千"),
    QING_2(116, "青"),
    RU_CHANG_TING(119, "请入场停车"),
    QING_TONG_GUO(120, "请通过"),
    QING_TONG_XING(121, "请通行"),
    REN_2(123, "人"),
    RI_2(124, "日"),
    RU_CHANG(125, "入场"),
    ENTRY_TIME(126, "入场时间"),
    ENTRY(127, "入口"),
    SHENG_YU(131, "剩余"),
    REMAINING_SPACE(132, "剩余车位"),
    REMAINING_DAYS(134, "剩余天数为"),
    SHI_2(135, "十"),
    SHI_JIAN(137, "时间"),
    SHI_3(138, "使"),
    SHOU_FEI_2(139, "收费"),
    TAI_2(142, "台"),
    TIAN_2(143, "天"),
    PARKING(144, "停车"),
    PARKING_DURATION(145, "停车时长"),
    PARKING_VALIDITY(146, "停车有效期"),
    WAN_3(147, "万"),
    WEI_2(148, "为"),
    WEI_3(149, "未"),
    UNAUTHORIZED(150, "未授权"),
    WEI_4(151, "位"),
    NO_EXIT_RIGHT(152, "无权出场"),
    NO_ENTRY_RIGHT(153, "无权入场"),
    XIAO_SHI(155, "小时"),
    XIN_2(157, "新"),
    XUE_2(158, "学"),
    YI_GUO_QI(161, "已过期"),
    YI_JIAO_FEI(162, "已缴费"),
    VALID_UNTIL(163, "有效期至"),
    YUE_2(167, "月"),
    MONTHLY_CAR_2(169, "月租车"),
    MONTHLY_REMAINING(170, "月租车剩余"),
    MONTHLY_EXPIRED(171, "月租车已到期"),
    MONTHLY_EXPIRED_2(172, "月租已到期"),
    ZHENG_2(177, "整"),
    ZHENG_3(178, "正"),
    WISH_SAFE_TRIP(178, "祝您一路平安"),
    WISH_GOOD_TRIP(179, "祝您一路顺风"),
    ETCP_SERVICE(180, "ETCP为您服务"),
    M_NULL(181, "MNull"),
    S_NULL(182, "SNull"),
    SPACE_OCCUPIED(183, "本车位已停车"),
    BAUD_RATE(184, "波特率为"),
    OPERATION_SUCCESS(185, "操作成功"),
    EXCEED_EXIT_TIME(186, "超过离场限时"),
    TIMEOUT_PAYMENT(187, "超时交费"),
    PLATE_EXPIRED(188, "车号已过期"),
    CAR_EXIT_FORBIDDEN(189, "车辆禁止出场"),
    CAR_MATCH_ERROR(190, "车辆匹配异常"),
    PLATE_MISMATCH(191, "车牌不符"),
    PLATE_MATCH_ERROR(192, "车牌匹配异常"),
    PLATE_RECOGNITION_FAILED(193, "车牌识别失败"),
    SPACE_IN_USE(194, "车位已使用"),
    SPACE_USED(195, "车位已用"),
    SPACE_FULL(196, "车位已用完"),
    SPACE_AVAILABLE(197, "车位有余"),
    EXIT(198, "出场"),
    EXIT_2(199, "出口"),
    CHRISTMAS_GREETING(201, "春节快乐"),
    INVALID_PLATE(202, "此车号无效"),
    BLACKLIST_CAR(203, "此车为黑名单车辆"),
    UNREGISTERED_CAR(204, "此车未登记"),
    SPACE_ALREADY_IN(205, "此车位车辆已进场"),
    SPACE_ALREADY_ENTERED(206, "此车位车辆已经入场"),
    CAR_TIMEOUT(207, "此车已超时"),
    CARD_UNREGISTERED(208, "此卡未登记"),
    CARD_EXITED(209, "此卡已出场"),
    CARD_LOST(210, "此卡已挂失"),
    CARD_EXPIRED(211, "此卡已过期"),
    CARD_LOCKED(212, "此卡已锁定"),
    CARD_IN_USE(213, "此卡已在场"),
    CARD_CANCELLED(214, "此卡已注销"),
    ADDRESS(215, "地址"),
    ADDRESS_IS(216, "地址为"),
    PORT(217, "端口"),
    PORT_IS(218, "端口为"),
    SORRY(219, "对不起"),
    QR_CODE(220, "二维码"),
    PAYMENT_CODE(221, "付款码"),
    TIME_SLOT_FORBIDDEN(222, "该时段不允许进入"),
    CONTROLLED_CAR(223, "管控车辆"),
    NATIONAL_DAY_GREETING(225, "国庆节快乐"),
    EXPIRED_EXIT(226, "过期出场"),
    EXPIRED_ENTRY(227, "过期入场"),
    BLACKLIST_CARD(228, "黑名单卡"),
    WELCOME_PARK(229, "欢迎泊车"),
    WELCOME_LOGIN(230, "欢迎登录"),
    WELCOME_HOME(231, "欢迎回家"),
    WELCOME_ENTER(232, "欢迎入场"),
    WELCOME_PLATE_RECOGNITION(233, "欢迎使用车牌识别"),
    WELCOME_NEXT_TIME(234, "欢迎下次光临"),
    WELCOME_AGAIN(235, "欢迎再次光临"),
    MEMBER_CAR(236, "会员车"),
    JIN_CHU_YAN_SHI(238, "进出延时"),
    EXIT_FORBIDDEN(239, "禁止出场"),
    ACCESS_FORBIDDEN(240, "禁止出入"),
    CARD_PICKUP_FORBIDDEN(241, "禁止取卡"),
    ENTRY_FORBIDDEN(242, "禁止入场"),
    ACCESS_DENIED(243, "拒绝进入"),
    POLICE_FREE_PASS(244, "军警车免费通行"),
    GATE_OPEN_NOTICE(245, "开闸请注意"),
    DEDUCTION_SUCCESS_2(246, "扣款成功"),
    LABOR_DAY_GREETING(248, "劳动节快乐"),
    TEMPORARY_SPACE_FULL(249, "临时车位已满"),
    TEMPORARY_NO_RIGHT(250, "临时车无权限"),
    TEMPORARY_NO_RECORD(251, "临时车无入场记录"),
    FREE_CAR(252, "免费车辆"),
    FREE_PASS(253, "免费放行"),
    FREE_PARKING(254, "免费停车"),
    FREE_ACCESS(255, "免费通行"),
    INTERNAL_NO_ACCESS(256, "内部车场不允许进入"),
    EXPRESS_NOTICE(257, "您有快递在管理处"),
    UNPAID_EXIT(258, "欠费外出"),
    PLEASE_RECHARGE(259, "请充值"),
    PLEASE_PAY_ADMIN(260, "请到管理处缴费"),
    PLEASE_WAIT_CONFIRM(261, "请等待确认"),
    PLEASE_WAIT_CONFIRM_PASS(262, "请等待确认放行"),
    PLEASE_WAIT_MANUAL(263, "请等待人工放行"),
    PLEASE_PAY_MANAGEMENT(264, "请及时缴纳管理费"),
    PLEASE_PAY_UTILITIES(265, "请及时缴纳水电费"),
    PLEASE_EXTEND_SOON(266, "请尽快延期"),
    PLEASE_PULL_OVER(267, "请靠边停车检查"),
    PLEASE_ENTER_2(268, "请入场"),
    PLEASE_SCAN_2(270, "请扫描屏上二维码"),
    PLEASE_WAIT_2(272, "请稍候"),
    PLEASE_USE(273, "请使用"),
    PLEASE_STOP_CHECK(274, "请停车检查"),
    PLEASE_PAY_FIRST(275, "请先到中心岗亭缴费"),
    PLEASE_LOGIN_FIRST(276, "请先登录操作员"),
    PLEASE_CONTACT_ADMIN(277, "请与管理员联系"),
    PLEASE_AT(278, "请在"),
    PLEASE_REPAY(279, "请重新补交停车费"),
    PLEASE_REPAY_2(280, "请重新缴费"),
    PLEASE_RECOGNIZE_AGAIN(281, "请重新进入识别区"),
    PLEASE_NOTE(282, "请注意"),
    AREA_FULL(283, "区已满"),
    MANUAL_GATE_OPEN(284, "人工开闸"),
    MANUAL_GATE_CLOSE(285, "人工落闸"),
    QR_CODE_PAYMENT(286, "扫码支付"),
    CHRISTMAS_GREETING_2(287, "圣诞节快乐"),
    RECOGNITION_SUCCESS(288, "识别成功"),
    CHARGING(289, "收费中"),
    MANUAL_PASS(290, "手动放行"),
    MANUAL_GATE_CLOSE_2(291, "手动关闸"),
    MANUAL_GATE_OPEN_2(292, "手动开闸"),
    MOBILE(293, "手机"),
    CARD_SUCCESS(294, "刷卡成功"),
    GATE_HOLD(295, "抬闸保持"),
    EXTERNAL_SPACE_FULL(296, "外来车位已满"),
    UNPAID_PLEASE_PAY(298, "未缴费请到缴费处缴费"),
    NO_MANUAL_ENTRY(299, "无法人工入场"),
    NO_ENTRY(300, "无法入场"),
    NO_RECORD(302, "无入场记录"),
    NO_REMAINING_SPACE(303, "无剩余车位"),
    NO_ACCESS_RIGHT(304, "无通行权限"),
    SYSTEM_EXPIRED(305, "系统过期"),
    SYSTEM_START(306, "系统开始"),
    SYSTEM_EXIT(307, "系统退出"),
    CURRENT_TIME(308, "现在时间"),
    INFO_CONFIRMED(310, "信息已确认"),
    OWNER_CAR(312, "业主车辆"),
    TIMEOUT(313, "已超时"),
    BALANCE(318, "余额"),
    BALANCE_INSUFFICIENT(319, "余额不足"),
    BALANCE_INSUFFICIENT_RECHARGE(320, "余额不足请及时充值"),
    BALANCE_IS(321, "余额为"),
    NEW_YEAR_GREETING(322, "元旦节快乐"),
    MONTHLY_UNAUTHORIZED(323, "月租车未授权"),
    MONTHLY_EXPIRING(324, "月租快到期"),
    ALLOW_CARD_PICKUP(325, "允许取卡"),
    ALLOW_ENTRY(326, "允许入场"),
    PAUSE_USE(327, "暂停使用"),
    REPEAT_CARD_READ(334, "重复读卡"),
    REPEAT_ENTRY(335, "重复进入"),
    REPEAT_ENTRY_NOT_ALLOWED(336, "重复进入不允许"),
    REPEAT_EXIT(337, "重复外出"),
    REPEAT_EXIT_NOT_ALLOWED(338, "重复外出不允许"),
    SAFETY_NOTICE(339, "注意安全");

    private final int code;
    private final String content;

    /**
     * 根据内容查找音频代码
     * @param content 音频内容
     * @return 音频代码枚举,如果未找到返回null
     */
    public static DtongLcdAudioCode findByContent(String content) {
        if (content == null || content.isEmpty()) {
            return null;
        }
        for (DtongLcdAudioCode code : values()) {
            if (code.getContent().equals(content)) {
                return code;
            }
        }
        return null;
    }

    /**
     * 根据代码查找音频代码
     * @param code 音频代码
     * @return 音频代码枚举,如果未找到返回null
     */
    public static DtongLcdAudioCode findByCode(int code) {
        for (DtongLcdAudioCode audioCode : values()) {
            if (audioCode.getCode() == code) {
                return audioCode;
            }
        }
        return null;
    }
} 