package com.icetech.park.service.down.full.controlcard;

import com.icetech.cloudcenter.domain.request.p2c.HintRequest;

import java.time.LocalTime;
import java.util.List;

/**
 * @author fangct
 */
public interface IControlCardTypeBuilder {

    List<byte[]> initControlCard(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime, int tts);
    /**
     * 构建一个表示设置音量的字节数组。
     *
     * @param volume 需要设置的音量值。
     * @param enable 是否开启勿扰模式。
     * @param quietVolume 勿扰模式的音量值，通常为0表示静音。
     * @param startTime 勿扰的开始时间，使用LocalTime表示。
     * @param endTime 勿扰的结束时间，使用LocalTime表示。
     * @return byte[] 包含勿扰音量配置的字节数组。
     */
    List<byte[]> buildSetVolume(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime);
    /**
     * 构建语音序列数据
     *
     * @param say 语音内容字符串，用于生成下载序列数据。
     * @return byte[] 包含生成的语音下载序列数据的对象。
     */
    byte[] buildSayByte(String say);

    /**
     * 构建数组，显示相关的序列数据
     *
     * @param colors 每行的颜色值，以逗号分隔。
     * @param ledRestoreDefaultTime 繁忙显示的时间
     * @param hintRequest 显示信息，包含显示内容、显示时间等。
     * @param busyStatus 设备忙闲状态，true表示设备忙，false表示设备空闲。
     * @return List<byte[]> 包含生成的多个下载序列数据对象的列表。
     */
    List<byte[]> buildShowBytes(String colors, int ledRestoreDefaultTime, HintRequest hintRequest, boolean busyStatus);

    /**
     * 是否在多包间增加延迟时间
     * @return 是否延迟
     */
    default Boolean isMultiplePackSleep() {
        return false;
    }
}
