package com.icetech.park.service.down.full.controlcard;

import com.icetech.park.service.down.full.controlcard.dtong_lcd.DtongLcdCardService;
import com.icetech.park.service.down.full.controlcard.dtong_led.DtongLedCardService;
import com.icetech.park.service.down.full.controlcard.vertical_2x8.FangKongCardService;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author fangct
 */
@Slf4j
@Getter
public class ControlCardTypeServiceFactory {

    /**
     * 控制卡实例对象
     */
    private static Map<Integer, IControlCardTypeBuilder> instanceMap = new ConcurrentHashMap<>();

    public static IControlCardTypeBuilder getControlCardTypeBuilder(Integer type) {
        switch (type) {
            case 18:
                log.info("使用方控控制卡生成器");
                break;
            case 4:
                log.info("使用道通LCD控制卡生成器");
                break;
            case 6:
                log.info("使用道通LED控制卡生成器");
                break;
        }
        if (instanceMap.containsKey(type)) {
            return instanceMap.get(type);
        }
        IControlCardTypeBuilder builder = null;
        switch (type) {
            case 18:
                builder = new FangKongCardService();
                break;
            case 4:
                builder = new DtongLcdCardService();
                break;
            case 6:
                builder = new DtongLedCardService();
                break;
        }
        instanceMap.put(type, builder);
        return builder;
    }

}
