package com.icetech.park.service.down.full.controlcard;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fangct
 */
@Getter
public enum ControlCardTypeEnum {
    /** 方控 */
    FANG_KONG(18, "方控"),
    /** 道通LCD */
    DTONG_LCD(4, "道通LCD"),
    /** 道通LED */
    DTONG_LED(6, "道通LED"),
    ;

    private int type;
    private String desc;

    ControlCardTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, ControlCardTypeEnum> NAME_MAP;

    static {
        ControlCardTypeEnum[] cmds = ControlCardTypeEnum.values();
        NAME_MAP = new HashMap<>(cmds.length);
        for (ControlCardTypeEnum cmd : cmds) {
            NAME_MAP.put(cmd.getType(), cmd);
        }
    }

    public static ControlCardTypeEnum getByType(int type) {
        return NAME_MAP.get(type);
    }

}
