package com.icetech.park.service.down.full;

import com.icetech.basics.domain.SendMessage;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.SendMsgCommon;
import com.icetech.park.service.handle.FullCloudDownHandle;
import com.icetech.third.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.icetech.basics.constants.TextConstant.CAMERA_OFF_LINE;
import static com.icetech.basics.constants.TextConstant.CAMERA_VERSION_LOW;
import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.THREE;
import static com.icetech.basics.constants.TextConstant.TIME_OUT_SEND_FAIL;

@Service
@Slf4j
public class FullCloudSendMsgServiceImpl extends SendMsgCommon {

    @Autowired
    private FullCloudDownHandle downHandle;

    @Override
    public <T, R> ObjectResponse<R> send(Message<T> message, String sendDevices, String parkCode) {
        T payload = message.getPayload();
        String[] targetArr = sendDevices.split(";");
        if (targetArr.length == 0) {
            return ObjectResponse.success();
        }
        SendMessage sendMessage = SendMessage.builder()
                .type(THREE)
                .build();
        boolean hasFail = false;
        String lastDeviceVersion = null;
        List<SendMessage.Describe> offLineDescribes = new ArrayList<>();
        List<SendMessage.Describe> failDescribes = new ArrayList<>();
        List<SendMessage.Describe> lowVerDescribes = new ArrayList<>();
        for (String serialNumber : targetArr) {
            if (serialNumber == null || serialNumber.trim().isEmpty()) {
                continue;
            }
            TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(serialNumber);
            if (tokenDeviceVo == null) {
                hasFail = true;
                if (CollectionUtils.isNotEmpty(offLineDescribes)) {
                    for (SendMessage.Describe describe : offLineDescribes) {
                        List<String> serialNumbers = describe.getSerialNumbers();
                        if (CollectionUtils.isEmpty(serialNumbers)) {
                            serialNumbers.add(serialNumber);
                        } else {
                            if (!serialNumbers.contains(serialNumber)) {
                                serialNumbers.add(serialNumber);
                            }
                        }
                    }
                } else {
                    List<String> nums = new ArrayList<>();
                    nums.add(serialNumber);
                    offLineDescribes.add(SendMessage.Describe.builder()
                            .failType(CAMERA_OFF_LINE)
                            .serialNumbers(nums)
                            .build());
                }
                log.info("[下发业务数据] 设备序列号[{}]不在线", serialNumber);
                continue;
            }

            if (tokenDeviceVo.getVersion() != null && !tokenDeviceVo.getVersion().equals(lastDeviceVersion)) {
                try {
                    //根据版本号，重新构建参数
                    if (payload instanceof List) {
                        List list = (List) payload;
                        Object object = list.get(0);
                        if (object instanceof Request) {
                            for (Object o : list) {
                                Request request = (Request) o;
                                request.buildByVersion(tokenDeviceVo.getVersion());
                            }
                        }
                    } else if (payload instanceof Request) {
                        Request request = (Request) payload;
                        request.buildByVersion(tokenDeviceVo.getVersion());
                    }
                } catch (ResponseBodyException re) {
                    hasFail = true;
                    if (CollectionUtils.isNotEmpty(lowVerDescribes)) {
                        for (SendMessage.Describe describe : lowVerDescribes) {
                            List<String> serialNumbers = describe.getSerialNumbers();
                            List<String> versions = describe.getVersions();
                            if (CollectionUtils.isEmpty(serialNumbers)) {
                                serialNumbers.add(serialNumber);
                                versions.add(tokenDeviceVo.getVersion());
                            } else {
                                if (!serialNumbers.contains(serialNumber)) {
                                    serialNumbers.add(serialNumber);
                                    versions.add(tokenDeviceVo.getVersion());
                                }
                            }
                        }
                    } else {
                        List<String> nums = new ArrayList<>();
                        nums.add(serialNumber);
                        List<String> versions = new ArrayList<>();
                        versions.add(tokenDeviceVo.getVersion());
                        lowVerDescribes.add(SendMessage.Describe.builder()
                                .failType(CAMERA_VERSION_LOW)
                                .serialNumbers(nums)
                                .versions(versions)
                                .build());
                    }
                    continue;
                }
            }

            //下发
            String messageId = downHandle.send(parkCode, serialNumber, message);
            if (messageId == null) {
                hasFail = true;
                if (CollectionUtils.isEmpty(failDescribes)) {
                    List<String> nums = new ArrayList<>();
                    nums.add(serialNumber);
                    offLineDescribes.add(SendMessage.Describe.builder()
                            .failType(TIME_OUT_SEND_FAIL)
                            .serialNumbers(nums)
                            .build());
                } else {
                    for (SendMessage.Describe describe : offLineDescribes) {
                        List<String> serialNumbers = describe.getSerialNumbers();
                        if (CollectionUtils.isEmpty(serialNumbers)) {
                            serialNumbers.add(serialNumber);
                        } else {
                            if (!serialNumbers.contains(serialNumber)) {
                                serialNumbers.add(serialNumber);
                            }
                        }
                    }
                }
            }
            lastDeviceVersion = tokenDeviceVo.getVersion();
        }
        if (hasFail) {
            offLineDescribes.addAll(failDescribes);
            offLineDescribes.addAll(lowVerDescribes);
            sendMessage.setDescribes(offLineDescribes);
            log.info("[纯云-业务数据下发] 设备不在线或响应超时, 参数[{}]", message);
            return ObjectResponse.failed(ERROR_410, JsonUtils.toJson(sendMessage));
        } else {
            return ObjectResponse.success();
        }
    }

}
