package com.icetech.park.service.down;

import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * 端云-业务数据下发
 */
public interface SendMsgService {

    /**
     * 发送到车场所有设备
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2Park(SendRequest sendRequest, String parkCode, T... objPara);
    /**
     * 发送到车场所有主通道设备
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2MasterChannel(SendRequest sendRequest, String parkCode, T... objPara);

    /**
     * 发送到车场的出口相机
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2Exit(SendRequest sendRequest, String parkCode, T... objPara);

    /**
     * 发送到车场的入口相机
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2Enter(SendRequest sendRequest, String parkCode, T... objPara);

    /**
     * 发送到车场的其他出口相机
     * @param serialNumber 设备SN
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2ParkOtherExit(String serialNumber, SendRequest sendRequest, String parkCode, T... objPara);

    /**
     * 发送到车场的指定相机
     * @param sendDevices 下发的设备SN集合
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2Devices(String sendDevices, SendRequest sendRequest, String parkCode, T... objPara);

    /**
     * 发送到车场的指定通道相机
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param channelCode 通道编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2Channel(SendRequest sendRequest, String parkCode, String channelCode, T... objPara);

    /**
     * 发送到主出口相机
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2MasterExit(SendRequest sendRequest, String parkCode, T... objPara);

    /**
     * 发送到其他主出口相机
     * @param serialNumber 设备SN
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2OtherMasterExit(String serialNumber, SendRequest sendRequest, String parkCode, T... objPara);

    /**
     * 发送给某区域的子通道
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param regionId 车场ID
     * @param objPara 业务参数
     * @param <T> 下发实体
     * @param <R> 响应类型
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2RegionSubChannel(SendRequest sendRequest, String parkCode, Long regionId, T... objPara);
    /**
     * 发送给不包括主出口的其他相机
     * @param sendRequest 下发实体参数
     * @param parkCode 车场编号
     * @param objPara 业务参数
     * @param <T> 下发实体
     * @param <R> 响应类型
     * @return 响应
     */
    <T, R> ObjectResponse<R> send2ExcludeMasterExit(SendRequest sendRequest, String parkCode, T... objPara);
}
