package com.icetech.park.service.down;

import com.icetech.cloudcenter.domain.request.p2c.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * 远程开关闸接口
 */
public interface RemoteOperaService {
    ObjectResponse<Void> execute(Integer switchType, String parkCode, String serialNumber, String plateNum,
                                 String topic, RemoteSwitchRequest.ExtraInfo extraInfo);

    ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum);

    ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, String parkCode, String channelId, String plateNum);

    ObjectResponse<RemoteSwitchResponse> secondOpen(RemoteSwitchRequest remoteSwitchRequest, Long parkId, String parkCode, String serialNumber);

    String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, Integer sequenceId, String topic);

    String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, String topic);

    String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum);
}
