package com.icetech.park.service.down;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.PayChannelConstants;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.common.constants.EnexRecordTypeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.open.domain.enumeration.AppPayWay;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.handle.CacheHandle;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * 远程开关闸接口
 */
@Slf4j
public class RemoteOperaCommon {

    @Autowired
    protected OrderService orderService;
    @Autowired
    protected OrderPayService orderPayService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected ChannelAlarmDao channelAlarmDao;
    @Autowired
    protected CarOrderEnterService carOrderEnterService;
    @Autowired
    protected CarOrderExitService carOrderExitService;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected ParkService parkService;


    protected boolean delRemoteSwitchResponse(OpenBrakeRequest openBrakeRequest, String parkCode,
                                           RemoteSwitchResponse remoteSwitchResponse, Long parkId) {
        if (remoteSwitchResponse.getResult().equals(1)){
            //用户操作的车牌号
            String sourcePlateNum = openBrakeRequest.getPlateNum();
            //最终进出场流程要处理的车牌
            String plateNum = sourcePlateNum;
            //缓存中的车牌
            String cachePlateNum = null;
            CarEnterRequest enterRequest = null;
            CarExitRequest exitRequest = null;
            if (openBrakeRequest.getRecordType() == EnexRecordTypeConstants.EXIT) {
                exitRequest = cacheHandle.getExit(parkCode, openBrakeRequest.getAisleCode());
                if (exitRequest != null) {
                    cachePlateNum = exitRequest.getPlateNum();
                }
                if (StringUtils.isBlank(sourcePlateNum)) {
                    plateNum = cachePlateNum;
                    if (exitRequest != null) {
                        openBrakeRequest.setOrderNum(exitRequest.getOrderNum());
                    }
                } else {
                    if (!sourcePlateNum.equals(cachePlateNum) && StringUtils.isNotBlank(cachePlateNum)) {
                        log.warn("[手动开闸] 前端传车牌号和当前通道车牌不一致, 以前端传的车牌处理, 前端传车牌号[{}], 当前车牌[{}]",
                                sourcePlateNum, cachePlateNum);
                        exitRequest = null;
                        //可能前端传的订单号和车牌号不对应，设置为空，方便重新查询订单
                        openBrakeRequest.setOrderNum(null);
                    }
                }
            } else {
                enterRequest = cacheHandle.getEntrance(parkCode, openBrakeRequest.getAisleCode());
                if (enterRequest != null) {
                    cachePlateNum = enterRequest.getPlateNum();
                }
                if (StringUtils.isBlank(sourcePlateNum)) {
                    plateNum = cachePlateNum;
                } else {
                    if (!sourcePlateNum.equals(cachePlateNum) && StringUtils.isNotBlank(cachePlateNum)) {
                        log.warn("[手动开闸] 前端传车牌号和当前通道车牌不一致, 以缓存车牌处理, 前端传车牌号[{}], 当前车牌[{}]",
                                sourcePlateNum, cachePlateNum);
                        plateNum = cachePlateNum;
                    }
                }
            }
            openBrakeRequest.setPlateNum(plateNum);
            addOpeningRecord(openBrakeRequest, remoteSwitchResponse.getImage(), remoteSwitchResponse.getExecuteTime(), null, parkId);

            if (StringUtils.isBlank(plateNum)) {
                return true;
            }
            //异常离场
            if (openBrakeRequest.getRecordType() == EnexRecordTypeConstants.EXIT){
                exceptionExit(openBrakeRequest, exitRequest, parkCode, plateNum);
                //清除缓存中的上次异常记录
                cacheHandle.removeExit(parkCode, openBrakeRequest.getAisleCode());
            }else if (openBrakeRequest.getRecordType() == EnexRecordTypeConstants.ENTER){
                ObjectResponse<Void> objectResponse = enter(openBrakeRequest, enterRequest, plateNum, parkId, parkCode);
                log.info("人工开闸入场, 参数[{}], [{}]", openBrakeRequest, objectResponse);
                //清除缓存中的上次异常记录
                cacheHandle.removeEntrace(parkCode, openBrakeRequest.getAisleCode());
            }
            return true;
        }
        return false;
    }

    protected void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime, String imagePath, Long parkId) {
    }

    /**
     * 异常离场
     * @param openBrakeRequest 开闸实体
     * @param exitRequest 出口识别信息
     * @param parkCode 车场编号
     * @param plateNum 车牌号
     */
    protected void exceptionExit(OpenBrakeRequest openBrakeRequest, CarExitRequest exitRequest, String parkCode, String plateNum) {
        ObjectResponse<OrderInfo> inPark;
        if (StringUtils.isBlank(openBrakeRequest.getOrderNum())) {
            inPark = orderService.findInPark(plateNum, parkCode);
        } else {
            inPark = orderService.findByOrderNum(openBrakeRequest.getOrderNum());
        }
        if (ObjectResponse.isSuccess(inPark)){
            OrderInfo orderInfo = inPark.getData();
            QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(parkCode, openBrakeRequest.getAisleCode());
            if (channelFee == null || !channelFee.getOrderNum().equals(orderInfo.getOrderNum())) {
                QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
                queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
                queryOrderFeeRequest.setParkCode(parkCode);
                queryOrderFeeRequest.setPlateNum(openBrakeRequest.getPlateNum());
                queryOrderFeeRequest.setChannelId(openBrakeRequest.getAisleCode());
                ObjectResponse<QueryOrderFeeResponse> objectResponse = orderService.p2cQueryFee(queryOrderFeeRequest);
                channelFee = objectResponse.getData();
            }
            //记录全免优惠
            if (OrderOddStatusEnum.免费放行.getVal().equals(openBrakeRequest.getReasonType())) {
                if (channelFee != null && NumberUtils.parseDouble(channelFee.getUnpayPrice()) > 0) {
                    //记录支付明细优惠统计
                    OrderPayDiscount.TollCouponsInfo tollCouponsInfo = new OrderPayDiscount.TollCouponsInfo();
                    tollCouponsInfo.setExitTerminal(openBrakeRequest.getExitTerminal());
                    tollCouponsInfo.setDiscountPrice(NumberUtils.parseDecimal(channelFee.getUnpayPrice()));
                    tollCouponsInfo.setExitOperaAccount(openBrakeRequest.getOperAccount());
                    redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + orderInfo.getParkId() + ":" + orderInfo.getOrderNum(),
                            OrderPayDiscount.DiscountSourceEnum.TOLL_COUPONS.getDesc(), tollCouponsInfo, 60 * 60 * 24);

                    saveOrderPayWithFullDiscount(openBrakeRequest, orderInfo, channelFee);
                } else if (channelFee != null && NumberUtils.parseDouble(channelFee.getUnpayPrice()) == 0) {
                    saveOrderPayWithFullDiscount(openBrakeRequest, orderInfo, channelFee);
                }
            }

            if (exitRequest == null){
                exitRequest = new CarExitRequest();
                exitRequest.setParkCode(parkCode);
                exitRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                exitRequest.setParkId(orderInfo.getParkId());
                exitRequest.setType(orderInfo.getType());
                exitRequest.setExitTime(DateTools.unixTimestamp());
            }else{
                if (!exitRequest.getPlateNum().equals(plateNum)){
                    log.info("[手动开闸] 离场通道缓存的当前车牌号：{} 与开闸请求的车牌号：{} 不同", exitRequest.getPlateNum(), plateNum);
                }
            }
            exitRequest.setPlateNum(plateNum);
            exitRequest.setOrderNum(orderInfo.getOrderNum());
            exitRequest.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
            exitRequest.setOperAccount(openBrakeRequest.getOperAccount());
            exitRequest.setExitTerminal(openBrakeRequest.getExitTerminal());
            if (channelFee != null){
                exitRequest.setTotalAmount(channelFee.getTotalAmount());
                exitRequest.setPaidAmount(channelFee.getPaidAmount());
                //String discountPrice = NumberUtils.decimalAdd(channelFee.getDiscountPrice(), channelFee.getDiscountAmount()).toString();
                exitRequest.setDiscountAmount(channelFee.getDiscountAmount());
            }
            if (openBrakeRequest.getOperAccount() != null) {
                exitRequest.setOperAccount(openBrakeRequest.getOperAccount());
            }
            if (openBrakeRequest.getExitTerminal() != null) {
                exitRequest.setExitTerminal(openBrakeRequest.getExitTerminal());
            }
            exitRequest.setExitRemark(openBrakeRequest.getRemark());
            ObjectResponse<Map<String, Object>> exceptionExit = carOrderExitService.exceptionExit(exitRequest, openBrakeRequest.getReasonType());
            if (!ObjectResponse.isSuccess(exceptionExit)){
                log.info("[手动开闸] 异常离场失败, 参数：{}", exitRequest);
            }else{
                log.info("[手动开闸] 异常离场成功, 参数：{}", exitRequest);
            }
            cacheHandle.removeChannelFee(parkCode, openBrakeRequest.getAisleCode());
        }
    }

    /**
     * 保存全优惠的支付记录
     * @param openBrakeRequest 开闸参数
     * @param orderInfo 订单信息
     * @param channelFee 费用信息
     */
    private void saveOrderPayWithFullDiscount(OpenBrakeRequest openBrakeRequest, OrderInfo orderInfo, QueryOrderFeeResponse channelFee) {
        //记录支付明细
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(orderInfo.getOrderNum());
        orderPay.setPayStatus(PayStatusConstants.PAID);
        orderPay.setParkId(orderInfo.getParkId());
        orderPay.setDiscountPrice(NumberUtils.decimalAdd(channelFee.getUnpayPrice(), channelFee.getDiscountPrice()).toString());
        //支付类型
        orderPay.setPayChannel(PayChannelConstants.getPayChannelFromExitTerminal(openBrakeRequest.getExitTerminal()));
        //支付方式
        orderPay.setPayWay(AppPayWay.DISCOUNT_PAY.getCode());
        orderPay.setPaidPrice("0");
        orderPay.setOrderTime(channelFee.getQueryTime());
        orderPay.setPayTime(DateTools.unixTimestamp());
        orderPay.setTotalPrice(NumberUtils.decimalAdd(channelFee.getUnpayPrice(), channelFee.getDiscountPrice()).toString());
        orderPay.setTradeNo(CodeTools.GenerateTradeNo());
        orderPay.setIsSync(0);
        orderPay.setChannelId(openBrakeRequest.getAisleCode());
        orderPayService.addOrderPay(orderPay);

        channelFee.setDiscountPrice(NumberUtils.decimalAdd(channelFee.getUnpayPrice(), channelFee.getDiscountPrice()).toString());
        channelFee.setDiscountAmount(NumberUtils.decimalAdd(channelFee.getDiscountAmount(), channelFee.getDiscountPrice()).toString());
    }

    private ObjectResponse<Void> enter(OpenBrakeRequest openRequest, CarEnterRequest enterRequest, String plateNum, Long parkId, String parkCode) {
        ObjectResponse<?> resp;
        if (enterRequest != null) {
            enterRequest.setEnterTime(DateTools.unixTimestamp());
            enterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
            enterRequest.setRemark(openRequest.getRemark());
            //不再单独定义入口来源，统一用ExitTerminal来存放来源
            enterRequest.setEnterTerminal(openRequest.getExitTerminal());
            enterRequest.setOperaUser(openRequest.getOperAccount());
            resp = carOrderEnterService.enter(enterRequest);
        } else {
            CarEnterRequest carEnterRequest = new CarEnterRequest();
            carEnterRequest.setPlateNum(plateNum);
            carEnterRequest.setType(1);
            carEnterRequest.setEnterTime(DateTools.unixTimestamp());
            carEnterRequest.setCarType(1);
            carEnterRequest.setInandoutCode(openRequest.getAisleCode());
            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(parkId, openRequest.getAisleCode());
            ObjectResponse.notError(objectResponse);
            carEnterRequest.setInandoutName(objectResponse.getData().getInandoutName());
            //已开闸，在下层业务中判断车辆类型
            carEnterRequest.setOpenFlag(1);
            carEnterRequest.setTriggerType(2);
            carEnterRequest.setProperty(2);
            carEnterRequest.setParkId(parkId);
            carEnterRequest.setParkCode(parkCode);
            carEnterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
            carEnterRequest.setNoneEnterFlag(false);
            carEnterRequest.setRemark(openRequest.getRemark());
            //不再单独定义入口来源，统一用ExitTerminal来存放来源
            carEnterRequest.setEnterTerminal(openRequest.getExitTerminal());
            carEnterRequest.setOperaUser(openRequest.getOperAccount());
            resp = carOrderEnterService.enter(carEnterRequest);
        }
        return ObjectResponse.instance(resp);
    }
}
