package com.icetech.park.service.down;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.api.NoplateExitService;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.park.service.down.p2c.impl.P2cNoplateExitServiceImpl;
import com.icetech.park.service.down.pnc.impl.PncNoplateExitServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class NoplateExitServiceImpl implements NoplateExitService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cNoplateExitServiceImpl p2cFullCloudNoplateExitService;
    @Autowired
    private PncNoplateExitServiceImpl pncNoplateExitService;

    @Override
    public ObjectResponse<Void> noplateExit(NoplateExitRequest noplateExitRequest){
        log.info("进入无牌车离场，参数：{}", noplateExitRequest);
        ObjectResponse<Park> objectResponse = parkService.findByParkCode(noplateExitRequest.getParkCode());
        ObjectResponse.notError(objectResponse);
        Park park = objectResponse.getData();
        ObjectResponse<ParkConfig> parkConfigResponse = parkService.getParkConfig(park.getId());
        ObjectResponse.notError(parkConfigResponse);
        ParkConfig parkConfig = parkConfigResponse.getData();
        if (parkConfig.getDataCollection().equals(DataCollectionEnum.端网云.getType())) {
            return pncNoplateExitService.noplateExit(noplateExitRequest);
        }else{
            return p2cFullCloudNoplateExitService.noplateExit(noplateExitRequest);
        }
    }

}
