package com.icetech.park.service.down;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.api.NoplateEnterService;
import com.icetech.cloudcenter.domain.request.NoplateEnterRequest;
import com.icetech.park.service.down.p2c.impl.P2cNoplateEnterServiceImpl;
import com.icetech.park.service.down.pnc.impl.PncNoplateEnterServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoplateEnterServiceImpl implements NoplateEnterService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cNoplateEnterServiceImpl p2cNoplateEnterService;
    @Autowired
    private PncNoplateEnterServiceImpl pncNoplateEnterService;

    @Override
    public ObjectResponse<Void> noplateEnter(NoplateEnterRequest noplateEnterRequest){
        ObjectResponse<Park> objectResponse = parkService.findByParkCode(noplateEnterRequest.getParkCode());
        ObjectResponse.notError(objectResponse);
        Park park = objectResponse.getData();
        ObjectResponse<ParkConfig> parkConfigResponse = parkService.getParkConfig(park.getId());
        ObjectResponse.notError(parkConfigResponse);
        ParkConfig parkConfig = parkConfigResponse.getData();
        noplateEnterRequest.setInoutEvent(OrderCarInfoConstant.IN_OUT_WAY_QR_CODE);
        if (parkConfig.getDataCollection().equals(DataCollectionEnum.端网云.getType())){
            /*
             * 端网云架构
             */
            return pncNoplateEnterService.noplateEnter(noplateEnterRequest);
        }else{
            /*
             * 端云架构
             */
            return p2cNoplateEnterService.noplateEnter(noplateEnterRequest);
        }
    }

}
