package com.icetech.park.service.down;

import lombok.Data;

@Data
public class Message<T> {
    /**
     * 任务ID
     */
    private Long taskId;
    private Long recordId;
    /**
     * 车场ID
     */
    private Long parkId;
    /**
     * 任务调度业务类型
     */
    private Integer serviceType;

    /**
     * 业务id
     */
    private Long serviceId;

    /**
     * 实际下发对应的业务类型
     */
    private Integer reqServiceType;

    /**
     * 内容
     */
    private T payload;

    /**
     * 下一个下发内容，当上一个下发响应成功后，会下发当前内容
     */
    private T nextPayLoad;
    /**
     * 指定messageId下发
     */
    private String messageId;

    public Message() {
        super();
    }
    public Message(Long taskId, Long parkId, Integer serviceType, Long serviceId, Integer reqServiceType, T payload) {
        this.taskId = taskId;
        this.parkId = parkId;
        this.serviceType = serviceType;
        this.serviceId = serviceId;
        this.reqServiceType = reqServiceType;
        this.payload = payload;
    }
    public Message(Long parkId, Integer serviceType, Integer reqServiceType, T payload) {
        this.parkId = parkId;
        this.serviceType = serviceType;
        this.reqServiceType = reqServiceType;
        this.payload = payload;
    }

    public Message(Long taskId, Long parkId, Integer serviceType, Long serviceId, T payload) {
        this.taskId = taskId;
        this.parkId = parkId;
        this.serviceType = serviceType;
        this.serviceId = serviceId;
        this.reqServiceType = serviceType;
        this.payload = payload;
    }
    public Message(Long parkId, Integer serviceType, T payload) {
        this.parkId = parkId;
        this.serviceType = serviceType;
        this.reqServiceType = serviceType;
        this.payload = payload;
    }

    public Integer getReqServiceType(){
        if (this.reqServiceType == null){
            return this.serviceType;
        }else{
            return this.reqServiceType;
        }
    }
}
