package com.icetech.park.service.discount.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.order.dao.ParkDiscountUserchargeMapper;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.common.constants.SqlConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 优惠券使用规则配置表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-25
 */
@Service
public class ParkDiscountUserchargeServiceImpl extends BaseServiceImpl<ParkDiscountUserchargeMapper, ParkDiscountUsercharge> implements ParkDiscountUserchargeService {

    /**
     * Description: 根据ID查询 优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ParkDiscountUsercharge
     */
    @Override
    public ParkDiscountUsercharge getParkDiscountUserchargeById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkDiscountUsercharge (ParkDiscountUsercharge entity) {
        return save(entity);
    }

    /**
     * Description: 修改 优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkDiscountUsercharge (ParkDiscountUsercharge entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkDiscountUserchargeById (Long id) {
        return removeById(id);
    }

    @Override
    public ParkDiscountUsercharge getParkDiscountUserchargeByParkId(Long parkId) {
        return getOne(Wrappers.lambdaQuery(ParkDiscountUsercharge.class).eq(ParkDiscountUsercharge::getParkId,parkId).last(SqlConstant.LIMIT_ONE));
    }

}
