package com.icetech.park.service.discount.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.order.dao.OrderDiscountRefundMapper;
import com.icetech.cloudcenter.domain.discount.OrderDiscountRefund;
import com.icetech.park.service.discount.OrderDiscountRefundService;
import com.icetech.common.constants.SqlConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 优惠退费记录表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-25
 */
@Service
public class OrderDiscountRefundServiceImpl extends BaseServiceImpl<OrderDiscountRefundMapper, OrderDiscountRefund> implements OrderDiscountRefundService {

    /**
     * Description: 根据ID查询 优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return OrderDiscountRefund
     */
    @Override
    public OrderDiscountRefund getOrderDiscountRefundById (Long id) {
        return getById(id);
    }

    @Override
    public OrderDiscountRefund getOrderDiscountRefundByNo(String discountNo) {
        return getOne(Wrappers.lambdaQuery(OrderDiscountRefund.class).eq(OrderDiscountRefund::getDiscountNo,discountNo).last(SqlConstant.LIMIT_ONE));
    }

    /**
     * Description: 新增  优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addOrderDiscountRefund (OrderDiscountRefund entity) {
        return save(entity);
    }

    /**
     * Description: 修改 优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyOrderDiscountRefund (OrderDiscountRefund entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeOrderDiscountRefundById (Long id) {
        return removeById(id);
    }

}
