package com.icetech.park.service.discount;

import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 优惠券使用规则配置表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-25
 */
public interface ParkDiscountUserchargeService extends IBaseService<ParkDiscountUsercharge> {

    /**
     * Description: 根据ID查询 优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ParkDiscountUsercharge
     */
    ParkDiscountUsercharge getParkDiscountUserchargeById (Long id);

    /**
     * Description: 新增  优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkDiscountUsercharge (ParkDiscountUsercharge entity);

    /**
     * Description: 修改 优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkDiscountUsercharge (ParkDiscountUsercharge entity);

    /**
     * Description: 删除  优惠券使用规则配置表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkDiscountUserchargeById (Long id);

    /**
     * 根据车场id获取
     * @param parkId
     * @return
     */
    ParkDiscountUsercharge getParkDiscountUserchargeByParkId (Long parkId);
}
