package com.icetech.park.service.discount;

import com.icetech.cloudcenter.domain.discount.OrderDiscountRefund;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 优惠退费记录表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-25
 */
public interface OrderDiscountRefundService extends IBaseService<OrderDiscountRefund> {

    /**
     * Description: 根据ID查询 优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return OrderDiscountRefund
     */
    OrderDiscountRefund getOrderDiscountRefundById (Long id);

    /**
     * 根据优惠券编码查询
     * @param discountNo
     * @return
     */
    OrderDiscountRefund getOrderDiscountRefundByNo(String discountNo);

    /**
     * Description: 新增  优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderDiscountRefund (OrderDiscountRefund entity);

    /**
     * Description: 修改 优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyOrderDiscountRefund (OrderDiscountRefund entity);

    /**
     * Description: 删除  优惠退费记录表对象信息 <br>
     * Version1.0 2022-08-25 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeOrderDiscountRefundById (Long id);
}
