package com.icetech.park.service.catched;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.icetech.cloudcenter.api.catched.NoplateRecordService;
import com.icetech.park.dao.catched.NoplateRecordDao;
import com.icetech.park.domain.entity.catched.NoplateRecord;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: lisc
 * @Date: 2018/10/11 14:24
 * @Description: 无牌车入场纪录
 */
@Slf4j
@Service
public class NoplateRecordServiceImpl implements NoplateRecordService {
    @Autowired
    private NoplateRecordDao noplateRecordDao;
    @Override
    public String selectPlateByUnionId(NoplateRecord noplateRecord){
        return noplateRecordDao.selectPlateByUnionId(noplateRecord);
    }

    @Override
    public int update(NoplateRecord noplateRecordUpdate){
        return noplateRecordDao.update(noplateRecordUpdate,new QueryWrapper<>(noplateRecordUpdate));
    }

    @Override
    public int updateNoplateRecord(NoplateRecord noplateRecordUpdate, String oldStatus){
        return noplateRecordDao.updateNoplateRecord(noplateRecordUpdate, oldStatus);
    }

    @Override
    public NoplateRecord insert(NoplateRecord noplateRecord){
        noplateRecordDao.insert(noplateRecord);
        log.info("无牌车插入:{}",noplateRecord);
        return noplateRecord;
    }

    @Override
    public NoplateRecord selectById(String noplateRecordId){
        return noplateRecordDao.selectById(noplateRecordId);
    }

    @Override
    public int updateById(NoplateRecord noplateRecord){
        return noplateRecordDao.updateById(noplateRecord);
    }

    @Override
    public List<NoplateRecord> selectList(NoplateRecord noplateRecord){
        return noplateRecordDao.selectList(new QueryWrapper<>(noplateRecord).orderByDesc("enter_time"));
    }

    @Override
    public NoplateRecord selectLimitOne(NoplateRecord noplateRecord) {
        return noplateRecordDao.selectLimitOne(noplateRecord);
    }
}
