package com.icetech.park.service.catched;

import com.icetech.cloudcenter.api.catched.InvoiceUsercacheService;
import com.icetech.park.dao.catched.InvoiceUsercacheDao;
import com.icetech.park.domain.entity.catched.InvoiceUsercache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Auther: fangct
 * @Date: 2018/12/18
 * @Description: 发票用户数据缓存
 */
@Service
@Slf4j
public class InvoiceUsercacheServiceImpl implements InvoiceUsercacheService {
    @Resource
    private InvoiceUsercacheDao invoiceUsercacheDao;
    /**
     * 根据用户标识查询用户填写的记录
     * @param unionId
     * @return
     */
    @Override
    public InvoiceUsercache selectByUnionId(String unionId){
        return invoiceUsercacheDao.selectByUnionId(unionId);
    }


    /**
     * 更新
     * @param invoiceUsercache
     * @return
     */
    @Override
    public int update(InvoiceUsercache invoiceUsercache){
        return invoiceUsercacheDao.updateByUnionId(invoiceUsercache);
    }

    @Override
    public InvoiceUsercache insert(InvoiceUsercache invoiceUsercache){
        int insert = invoiceUsercacheDao.insert(invoiceUsercache);
        return invoiceUsercache;
    }
}
