package com.icetech.park.service.car.impl;

import com.icetech.park.dao.car.CarRegisterMapper;
import com.icetech.park.domain.entity.car.CarRegister;
import com.icetech.park.service.car.CarRegisterService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 盘点车辆登记表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-08-23
 */
@Service
public class CarRegisterServiceImpl extends BaseServiceImpl<CarRegisterMapper, CarRegister> implements CarRegisterService {

    /**
     * Description: 根据ID查询 盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param id 对象id
     * @return CarRegister
     */
    @Override
    public CarRegister getCarRegisterById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addCarRegister (CarRegister entity) {
        return save(entity);
    }

    /**
     * Description: 修改 盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyCarRegister (CarRegister entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeCarRegisterById (Long id) {
        return removeById(id);
    }

}
