package com.icetech.park.service.car;

import com.icetech.park.domain.entity.car.CarRegister;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 盘点车辆登记表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-08-23
 */
public interface CarRegisterService extends IBaseService<CarRegister> {

    /**
     * Description: 根据ID查询 盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param id 对象id
     * @return CarRegister
     */
    CarRegister getCarRegisterById (Long id);

    /**
     * Description: 新增  盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addCarRegister (CarRegister entity);

    /**
     * Description: 修改 盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyCarRegister (CarRegister entity);

    /**
     * Description: 删除  盘点车辆登记表对象信息 <br>
     * Version1.0 2022-08-23 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeCarRegisterById (Long id);
}
