package com.icetech.park.service.car;

import com.icetech.park.domain.entity.car.CarClean;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 盘点车辆清理表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-08-26
 */
public interface CarCleanService extends IBaseService<CarClean> {

    /**
     * Description: 根据ID查询 盘点车辆清理表对象信息 <br>
     * Version1.0 2022-08-26 by wanggang创建
     *
     * @param id 对象id
     * @return CarClean
     */
    CarClean getCarCleanById (Long id);

    /**
     * Description: 新增  盘点车辆清理表对象信息 <br>
     * Version1.0 2022-08-26 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addCarClean (CarClean entity);

    /**
     * Description: 修改 盘点车辆清理表对象信息 <br>
     * Version1.0 2022-08-26 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyCarClean (CarClean entity);

    /**
     * Description: 删除  盘点车辆清理表对象信息 <br>
     * Version1.0 2022-08-26 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeCarCleanById (Long id);
}
