package com.icetech.park.service.call.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.call.ICallMobileParkService;
import com.icetech.common.constants.SqlConstant;
import com.icetech.park.domain.entity.call.CallMobilePark;
import com.icetech.park.service.call.CallMobileParkService;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author wangzhiwei
 */
@Service("iCallMobileParkServiceImpl")
@Slf4j
public class ICallMobileParkServiceImpl implements ICallMobileParkService {

    @Autowired
    private CallMobileParkService callMobileParkService;

    @Override
    public ObjectResponse<CallMobilePark> save(CallMobilePark callMobilePark) {
        boolean save = callMobileParkService.save(callMobilePark);
        return save?ObjectResponse.success(callMobilePark):ObjectResponse.failed(CodeConstantsEnum.ERROR);
    }

    @Override
    public ObjectResponse<CallMobilePark> update(CallMobilePark callMobilePark) {
        boolean save = callMobileParkService.updateById(callMobilePark);
        return save?ObjectResponse.success(callMobilePark):ObjectResponse.failed(CodeConstantsEnum.ERROR);
    }

    @Override
    public ObjectResponse<CallMobilePark> getOne(CallMobilePark callMobilePark) {
        CallMobilePark mobilePark = callMobileParkService.getOne(Wrappers.lambdaQuery(callMobilePark).last(SqlConstant.LIMIT_ONE));
        return Objects.nonNull(mobilePark)?ObjectResponse.success(mobilePark):ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }
}
