package com.icetech.park.service.call.impl;

import com.icetech.park.dao.call.CallMobileParkMapper;
import com.icetech.park.domain.entity.call.CallMobilePark;
import com.icetech.park.service.call.CallMobileParkService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 用户手机通道绑定表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-14
 */
@Service
public class CallMobileParkServiceImpl extends BaseServiceImpl<CallMobileParkMapper, CallMobilePark> implements CallMobileParkService {

    /**
     * Description: 根据ID查询 用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return CallMobilePark
     */
    @Override
    public CallMobilePark getCallMobileParkById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addCallMobilePark (CallMobilePark entity) {
        return save(entity);
    }

    /**
     * Description: 修改 用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyCallMobilePark (CallMobilePark entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeCallMobileParkById (Long id) {
        return removeById(id);
    }

}
