package com.icetech.park.service.call;

import com.icetech.park.domain.entity.call.CallMobilePark;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 用户手机通道绑定表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-14
 */
public interface CallMobileParkService extends IBaseService<CallMobilePark> {

    /**
     * Description: 根据ID查询 用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return CallMobilePark
     */
    CallMobilePark getCallMobileParkById (Long id);

    /**
     * Description: 新增  用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addCallMobilePark (CallMobilePark entity);

    /**
     * Description: 修改 用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyCallMobilePark (CallMobilePark entity);

    /**
     * Description: 删除  用户手机通道绑定表对象信息 <br>
     * Version1.0 2021-12-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeCallMobileParkById (Long id);
}
