package com.icetech.park.service;

import com.icetech.cloudcenter.domain.request.pnc.DataCenterWsRequest;

/**
 * WebSocket 的操作接口
 */
public interface WsOperService {

    /**
     * 返回是否允许创建连接
     * @param clientName
     * @return
     */
    boolean connection(String clientName);
    /**
     * 返回是否允许创建连接
     * @param clientName
     * @return
     */
    boolean pncconnection(String clientName, DataCenterWsRequest dataCenterWsRequest);

    /**
     * 转发到对应service实现类 - 端云
     *
     * @param clientName
     * @param params
     * @return
     */
    String redirect(String clientName, String params);

    /**
     *  注册成功后的初始化操作
     * @param clientName
     * @return
     */
    void init(String clientName);
    /**
     * 转发到对应service实现类 - 端网云
     *
     * @param clientName
     * @param params
     * @return
     */
    String pncredirect(String clientName, String params);
}
