package com.icetech.park.service;

import com.icetech.cloudcenter.domain.request.CallLogRequest;
import com.icetech.cloudcenter.domain.request.QueryCallLogRequest;
import com.icetech.cloudcenter.domain.response.ParkCallLogDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.ParkCallLog;

import java.util.List;

/**
 * Description ParkCallLogService
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/10 11:14
 */
public interface ParkCallLogService {

    /**
     * 查询通话记录
     * @param queryCallLogRequest
     * @return
     */
    ObjectResponse countCallLogList(QueryCallLogRequest queryCallLogRequest);
    /**
     * 查询通话记录
     * @param queryCallLogRequest
     * @return
     */
    ObjectResponse<List<ParkCallLogDto>> getCallLogList(QueryCallLogRequest queryCallLogRequest);

    /**
     *
     * @param callLogRequest
     * @return
     */
    ObjectResponse addCallLog(CallLogRequest callLogRequest);

    /**
     * 增加通话记录
     * @param parkCallLog   log
     * @return
     */
    ObjectResponse<Boolean> saveCallLog(ParkCallLog parkCallLog);

}
