package com.icetech.park.service;

import com.icetech.cloudcenter.domain.vo.MadePlateVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.IotPlate;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.PlateRecheckVo;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 车牌二次识别 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-22
 */
public interface IotPlateService extends IBaseService<IotPlate> {
    
    /**
     * Description: 车牌复审数量查询
     * Version1.0 2021-07-23 by wgy 创建
     * 
     * @param managerInOutRequest 车牌id 集合
     * @param parkIds               车场id集合
     * @return java.lang.Integer       
     */
    Integer selectPlateCount(ManagerInOutRequest managerInOutRequest, String parkIds);

    /**
     * Description: 车牌复审列表查询
     * Version1.0 2021-07-23 by wgy 创建
     * 
     * @param request   请求参数
     * @param parkIds   车场ids    
     * @return java.util.List<com.icetech.cloudcenter.domain.vo.PlateRecheckVo>       
     */
    List<PlateRecheckVo> selectRecheckVo(ManagerInOutRequest request, String parkIds);

    /**
     * Description:  查询车牌复审列表
     * Version1.0 2021-07-27 by wgy 创建
     * 
     * @param orderNum    订单id
     * @return com.icetech.park.domain.entity.IotPlate       
     */
    List<IotPlate> selectIotPlateByOrderNum(String orderNum);

    /**
     * 获取车牌复审数量
     * @param managerInOutRequest 请求参数
     * @return Integer
     */
    ObjectResponse<Integer> getPlateRecheckCount(ManagerInOutRequest managerInOutRequest);

    /**
     * 车牌复审列表
     * @param managerInOutRequest   请求参数
     * @return List<PlateRecheckVo>
     */
    ObjectResponse<List<PlateRecheckVo>> getRecheckList(ManagerInOutRequest managerInOutRequest);

    /**
     * 车牌复审操作记录
     * @param managerInOutRequest   请求参数
     * @return List<MadePlateVo>
     */
    ObjectResponse<List<MadePlateVo>> getMadePlateList(ManagerInOutRequest managerInOutRequest);
    
    
}
