package com.icetech.park.service;

import com.icetech.park.service.flow.p2c.FlowCondition;

import java.util.Map;

/**
 *  屏显语音相关操作
 * @author fangct
 */
public interface IShowVoiceHandle {

    /**
     * 入场处理
     * @param para
     * @return
     */
    String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para);
    /**
     * 离场处理
     * @param para
     * @return
     */
    String exitHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para);

    default String enterFreeHandle(Long parkId, Long channelId, Map<String, Object> para) {
        return "";
    }

    default String exitFreeHandle(Long parkId, Long channelId, Map<String, Object> para) {
        return "";
    }

}
