package com.icetech.park.service.FenMiao.impl;

import com.icetech.cloudcenter.api.third.FenMiaoService;
import com.icetech.basics.dao.blacklist.BlacklistDao;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.cloudcenter.domain.constants.CardStatusConstants;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

@Service
@Slf4j
public class FenMiaoServiceImpl implements FenMiaoService {
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private BlacklistDao blacklistDao;
    @Autowired
    private MonthPlateDao monthPlateDao;
    @Autowired
    private SendinfoDao sendInfoDao;

    @Transactional
    @Override
    public ObjectResponse addMonth(MonthInfo monthInfo) {
        Long parkid = Long.valueOf(monthInfo.getParkId());
        Date startTime = monthInfo.getStartTime();
        Date endTime = monthInfo.getEndTime();
        //判断当前车场是否存在月卡产品
        MonthProduct monthProduct = monthProductDao.selectOneByParkId(parkid);
        //根据主车牌号查询上次开卡记录
        MonthInfo month = monthInfoDao.selectByPlateNum(parkid, monthInfo.getMainPlate(), null);
        //时间限制(不允许存在交叉的时间)
        if (Objects.nonNull(monthInfo) && monthInfo.getCardStatus() == 1){
            Date oldEndTime = monthInfo.getEndTime();
            if (startTime.getTime()<oldEndTime.getTime()){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
            }
        }
        if (Objects.isNull(monthProduct)){
            //创建月卡产品
            monthProduct = new MonthProduct();
            monthProduct.setName("自定义月卡产品");
            monthProduct.setParkId(parkid);
            monthProduct.setDuration(0);
            monthProduct.setCardType(1);
            monthProduct.setPaymoney(BigDecimal.ZERO);
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            monthProduct.setCheckStatus(1);
            monthProduct.setBuyChannel(1);
            monthProduct.setStatus(1);
            monthProductDao.insert(monthProduct);
        }else {
            //修改月卡产品
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            monthProductDao.update(monthProduct);
        }
        MonthRecord monthRecord = new MonthRecord();
        if (month == null || DateTools.differentDays(month.getEndTime(),startTime)>1){
            //新开卡
//            monthInfo = new MonthInfo();
            monthInfo.setParkId(parkid);
            monthInfo.setCardProperty(1);
            monthInfo.setCardOwner("");
            monthInfo.setProductId(monthProduct.getId());
            monthInfo.setPlotCount(1);
            monthInfo.setCount(1);
            monthInfo.setStartTime(startTime);
            monthInfo.setEndTime(endTime);
            monthInfo.setCardStatus(CardStatusConstants.生效中);
            monthInfoDao.insert(monthInfo);
            log.info("[分秒新开月卡] monthInfo:{}", JsonUtils.toString(monthInfo));
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.新增.getType());
        }else {
            // 更新
            monthInfo.setCardStatus(CardStatusConstants.生效中);
            monthInfo.setEndTime(endTime);
            monthInfo.setPlotCount(1);
            monthInfoDao.update(monthInfo);
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.续费.getType());
            monthRecord.setIsOverdue(0);
        }
        monthRecord.setProductId(monthProduct.getId());
        monthRecord.setParkId(monthProduct.getParkId());
        monthRecord.setCardProperty(monthInfo.getCardProperty());
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(monthInfo.getPlotCount());
        monthRecord.setCount(monthInfo.getCount());
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        monthRecord.setRemark(monthInfo.getRemark());
        monthRecord.setPlateNum(monthInfo.getMainPlate());
        monthRecord.setStartTime(monthInfo.getStartTime());
        monthRecord.setEndTime(monthInfo.getEndTime());
        monthRecord.setCreateTime(new Date());
        monthRecord.setUpdateTime(new Date());
        monthRecordDao.insert(monthRecord);
        MonthPlate monthPlate = new MonthPlate();
        monthPlate.setPlateNum(monthInfo.getMainPlate());
        monthPlate.setMonthId(monthInfo.getId());
        monthPlate.setParkId(monthInfo.getParkId());
        monthPlateDao.insert(monthPlate);
        SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.月卡.getServiceType());
        sendInfoDao.insert(sendInfo);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse delMonth(MonthInfo monthInfo) {
        int delete = monthInfoDao.delete(monthInfo.getId());
        if(delete > 0){
            return ObjectResponse.success();
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR);
    }

    @Override
    public ObjectResponse addBlack(Long parkId, String platenum,String stime,String etime) {
        SimpleDateFormat sf =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Blacklist black = new Blacklist();
            black.setParkId(parkId);
            black.setPlate(platenum);
            black.setCreateTime(sf.format(new Date()));
            black.setUpdateTime(sf.format(new Date()));
            black.setStartTime(stime);
            black.setEndTime(etime);
            black.setStatus(0);
            black.setType(1);
            int insert = blacklistDao.insert(black);
            if(insert > 0){
                return ObjectResponse.success();
            }
        }catch (Exception e){
            log.error("[分秒云]添加黑名单失败: {}. parkId[{}], platenum[{}], stime[{}], etime[{}]", e.getMessage(), parkId, platenum, stime, etime, e);
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR);
    }

    @Override
    public ObjectResponse delBlack(Long parkId, String platenum) {
        Blacklist blacklist = blacklistDao.selectValidByPlate(parkId, platenum);
        if(blacklist == null){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        blacklist.setStatus(1);
        int update = blacklistDao.updateBlack(blacklist);
        if(update > 0){
            return ObjectResponse.success();
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR);
    }
}
