package com.icetech.park.service;


import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.ChannelAlarmHandler;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.ChannelAlarmHandlerVo;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 进出口报警处理表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-21
 */
public interface ChannelAlarmHandlerService extends IBaseService<ChannelAlarmHandler> {

    /**
     * Description: 根据ID查询 进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param id 对象id
     * @return ChannelAlarmHandler
     */
    ChannelAlarmHandler getChannelAlarmHandlerById (Long id);

    /**
     * Description: 新增  进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addChannelAlarmHandler (ChannelAlarmHandler entity);

    /**
     * Description: 修改 进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyChannelAlarmHandler (ChannelAlarmHandler entity);

    /**
     * Description: 删除  进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeChannelAlarmHandlerById (Long id);

    /**
     * 查询滞留车辆人工处理记录
     * @param managerInOutRequest    请求参数
     * @param parkIds                车场id 集合
     * @return  List<ChannelAlarmHandlerVo>
     */
    List<ChannelAlarmHandlerVo> getChannelAlarmHandlerVoList(ManagerInOutRequest managerInOutRequest, String parkIds);

    /**
     * 滞留车辆人工处理
     * @param operAccount       操作账号
     * @param parkId            车场id
     * @param channelCode       通道编码
     * @return Boolean
     */
    ObjectResponse<Boolean> handlerChannelAlarm(String operAccount, Integer parkId, String channelCode);

    /**
     * 滞留车辆人工处理记录
     * @param managerInOutRequest   请求参数
     * @return ObjectResponse<List<ChannelAlarmHandlerVo>>
     */
    ObjectResponse<List<ChannelAlarmHandlerVo>> getHandlerChannelAlarmList(ManagerInOutRequest managerInOutRequest);
}
