package com.icetech.park.service;

import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.validator.Validator;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.handle.MorDownHandle;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseMorDownServiceImpl<T, R> implements ResponseService<String>, DownService<T, R> {

    @Autowired
    public MorDownHandle downHandle;
    @Autowired
    public MorCacheHandle cacheHandle;

    //CMD命令的返回后缀
    public static final String CMD_SUFFIX = "_resp";

    /**
     * 验证参数
     * @param instance 对象
     * @return 结果
     */
    protected void verifyParams(Object instance){
        if (!Validator.validate(instance)) {
            throw new ResponseBodyException(CodeConstants.ERROR_400, "检验参数未通过");
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, String cmd, Long parkId, String parkCode, String sn) {
        downHandle.dealResponse(p2cBaseResponse, parkId, MorDownCmdEnum.getCmdType(cmd));
    }

}
