package com.icetech.park.service;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.validator.Validator;

public abstract class AbstractService {
    //CMD命令的返回后缀
    public static final String CMD_SUFFIX = "_resp";

    /**
     * 验证参数
     * @param instance
     * @return
     */
    protected void verifyParams(Object instance){
        if (!Validator.validate(instance)) {
            throw new ResponseBodyException(CodeConstants.ERROR_400, "检验参数未通过");
        }
    }
}
